

/*********************************************************************/
/* Case-Control program, Version 5.0	                             */
/* Created by I. Zorych, e-mail: zorych@gmail.com    	             */
/*                       http://www.data-and-statistics.com          */
/* SAS 9.3                                                           */
/*                                                                   */
/* The code is modified for SAS 9.3                                  */
/* 03/2015                                                           */
/*********************************************************************/



/*******************************************************************
* DEFINE LIBRARIES and DIRECTORIES  	                           *
*******************************************************************/
/*  Define the name (abbreviation) of the database, up to 4 letters; (edit only right side) */
%let dbn_ = OSIM50;

/* Point to the SAS program (edit only right side) */
%let SAS_PROGRAM =  E:\SAS93\x86\SASFoundation\9.3\sas.exe;


/* Point to the work directory (edit only right side) */
%let wrkfolder =E:\CC_WIN\WRK;


/* Point to Data in the CDM format (edit only right side) */
%let cdmdata =F:\data1\OSIM11_50K;

/* Point to directory that contains parameter file, cc_parameters.txt, 
and (optionally) drugs_of_interest.txt, conditions_of_interest.txt. 
If either of optional files exists, it will influence the output and performance time  
(edit only right side)      */

%let Parameters_here =E:\0001_METHODS\CC_WIN\input_parameters\;
 

/* Point to the output directory (edit only right side)*/
%let outfolder = &wrkfolder;

/* Point to the directory for the output comma delimited file (edit only right side */
%let TEXT_OUT_DIR = &wrkfolder; 



/*******************************************************************
* END 'of DEFINE LIBRARIES and DIRECTORIES' section                *
*******************************************************************/

/* DON'T EDIT BELOW THIS LINE */
LIBNAME CDM "&cdmdata";  


%let datain=CDM;

LIBNAME WRK "&wrkfolder";
%let datawrk=WRK;

LIBNAME OUT "&outfolder";
%let dataout=OUT;

%let CC_parameters=&Parameters_here./CC_parameters.txt; 
%let drugs_of_interest=&Parameters_here./drugs_of_interest.txt;
%let conditions_of_interest=&Parameters_here./conditions_of_interest.txt;

%let indications=&Parameters_here./indications.txt;
%let CharlsonConcepts=&Parameters_here./CharlsonConcepts.txt;
%let CharlsonScoring=&Parameters_here./CharlsonScoring.txt;
%let pairs_of_interest=&Parameters_here./pairs_of_interest.txt;



%macro CC_method(datain, wrkfolder, datawrk, dataout, text_out_dir, cc_parameters, drugs_of_interest, conditions_of_interest);

/*******************************************************************/
* MACRO CC_method(Case Control method for "all-by-all" setup)*; 
* INPUT PARAMETERS:                                                *;
* datain    - library that stores working data in the CDM format   *;
* wrkfolder - location of the work folder                          *;
* datawrk   - working library output files                         *;
* dataout   - library for the output files                         *;
* text_out_dir - directory for the output text file                *;
* cc_parameters - parameters file                                  *;
* drugs_of_interest - drugs of interest file (may not exist)       *;
* conditions_of_interest - conditions of interest file             *;
*                           (may not exist)                        *;
/*******************************************************************/

options CPUCOUNT=ACTUAL THREADS;


%let cc=CCv5; /* Case_control program; version 5 */
/* tech parameters */
%let rrun=0;
%let B=25;
%let dire=&wrkfolder;

/* Read program parameters from cc_parameters.txt */
%let filrf=myfile;
%let rc=%sysfunc(filename(filrf, &CC_parameters));
%let fid=%sysfunc(fopen(&filrf));
%let rc=%sysfunc(fsep(&fid,%str(:,)));
%let i=1;
%if &fid > 0 %then
   %do %while(%sysfunc(fread(&fid)) = 0);
       %let rc=%sysfunc(fget(&fid,c,200));
       %let b&i = &c;
       %let i=%eval(&i+1);
    %end;
      %put &b1 &b2 &b3 &b4 &b5 &b6 &b7 &b8 &b9 &b10 &b11 &b12 &b13 &b14 &b15 &b16 &b17 &b18 &b19 &b20 &b21 &b22 &b23 &b24 &b25 &b26 &b27 &b28 &b29;
   %let rc=%sysfunc(fclose(&fid));
%let rc=%sysfunc(filename(filrf));
  
%macro nw(string);
%local count word;
%global nw word1;

%let count=1;

%let word=%qscan(&string,&count,%str(:;, ));
%let word1=&word;

%do %while(&word ne);
   %let count=%sysevalf(&count + 1);
   %let word=%qscan(&string,&count,%str(:;, ));
   %global word&count;
   %let word&count=&word;
%end;

%let nw=%eval(&count-1);
%mend nw;

%nw(&b1); %let num_part=%eval(&word2); %put num_part &num_part;
%nw(&b2); %let num_passes=%eval(&word2); %put num_passes &num_passes;
%nw(&b3); %let num_matches=%eval(&word2); %put num_matches &num_matches;
%nw(&b4); %let days_enrolled=%eval(&word2); %put days_enrolled &days_enrolled;
%nw(&b5); %let s_window=%eval(&word2); %put s_window &s_window;
%nw(&b6); %let p_window_drugs=%eval(&word2); %put p_window_drugs &p_w
ow_drugs;
%nw(&b7); %let p_window_cond=%eval(&word2); %put p_window_cond &p_window_cond;
%nw(&b8); %let del_interm=%eval(&word2); %put del_interm &del_interm;
%nw(&b9); %let B_days=%eval(&word2); %put B_days &B_days;

%nw(&b10); %let Drug_era_table=%scan(&word2,1); %put Drug_era_table &Drug_era_table;
%nw(&b11); %let Condition_era_table=%scan(&word2,1); %put Condition_era_table &Condition_era_table;
%nw(&b12); %let vis=%eval(&word2); %put VISITS &vis;
%nw(&b13); %let vdw=%eval(&word2); %put VDW &vdw;
%nw(&b14); %let ind_ind=%eval(&word2); %put ind_ind &ind_ind;
%nw(&b15); %let RLR=%eval(&word2); %put RLR &RLR;
%nw(&b16); %let blr=%eval(&word2); %put blr &blr;
%nw(&b17); %let cnds_blr=%eval(&word2); %put cnds_blr &cnds_blr;
%nw(&b18); %let dc_blr=%eval(&word2); %put dc_blr &dc_blr;
%nw(&b19); %let cc_blr=%eval(&word2); %put cc_blr &cc_blr;
%nw(&b20); %let vis_blr=%eval(&word2); %put vis_blr &vis_blr;
%nw(&b21); %let cha_blr=%eval(&word2); %put cha_blr &cha_blr;
%nw(&b22); %let hyper=%sysevalf(&word2); %put hyper  &hyper;
%nw(&b23); %let CLR=%eval(&word2); %put CLR &CLR;
%nw(&b24); %let CHA=%eval(&word2); %put CHA &CHA;
%nw(&b25); %let CHW=%eval(&word2); %put CHW &CHW;
%nw(&b26); %let cow=%eval(&word2); %put cow &cow;
%nw(&b27); %let drug_oc=%eval(&word2); %put drug_oc &drug_oc;
%nw(&b28); %let dbn_f=%scan(&word2,1); %put DBN from file &dbn_f;
%nw(&b29); %let rnm=%scan(&word2,1); %put rnm &rnm;


%if &dbn_f=NULL %then %do; %let dbn=&dbn_; %end; 
												%else %do; %let dbn=&dbn_f; %end;

%if &p_window_drugs=0 %then %do; %let PWD='6'; %put PWD &PWD; %end;
  %else %if &p_window_drugs=30 %then %do; %let PWD='7'; %end;
              %else %put ' WRONG SIZE OF THE DRUG PERSISTENCE WINDOW';

%if &p_window_cond=0 %then %do; %let PWC='64'; %end;
  %else %if &p_window_cond=30 %then %do; %let PWC='65'; %end;
              %else %put ' WRONG SIZE OF THE CONDITION PERSISTENCE WINDOW';
%let del_interm=0;

%if &CHA=1 %then %do;
%if &rrun=1 %then %do;
data &DATAWRK..CHA_concepts;
	infile "&CharlsonConcepts" firstobs=2 DLM=",";
	input Diag_category_id Target_concept_id Target_vocabulary_code;
run;

proc sort data=&DATAWRK..CHA_concepts;
by Diag_category_id;
run;

data &DATAWRK..CHA_scores;
	infile "&CharlsonScoring" firstobs=2 DLM=",";
	input Diag_category_id Diag_category $ Weight;
run;

proc sort data=&DATAWRK..CHA_scores;
by Diag_category_id;
run;

data &DATAWRK..CHA_concepts;
merge &DATAWRK..CHA_concepts (IN=SET1) &DATAWRK..CHA_scores (IN=SET2); 
by Diag_category_id;
if SET1 AND SET2;
run;

proc sort data=&DATAWRK..CHA_concepts NODUPKEY;
by Diag_category_id Target_concept_id Target_vocabulary_code;
run;
%end;
%end;



%if %sysfunc(fileexist(&indications)) %then 
%do; %put indications file exists;

	data &DATAWRK..indications;
	infile "&indications" DLM=',' firstobs=2;
	input Drug_concept_id Condition_concept_id;
	run;

	proc sort data=&DATAWRK..indications  out=&DATAWRK..indications_cond_uni (keep=Condition_concept_id) NODUPKEY;
	by Condition_concept_id;
	run;

	proc sort data=&DATAWRK..indications  out=&DATAWRK..indications_drug_uni (keep=Drug_concept_id) NODUPKEY;
	by Drug_concept_id;
	run;

	
%end;
%else %do; %put indications file DOES NOT exists; %end;


%if %sysfunc(fileexist(&pairs_of_interest)) %then 
%do; %put pairs_of_interest.txt file exists;

	data &DATAWRK..pairs_of_interest;
	infile "&pairs_of_interest" DLM=',' firstobs=2;
	input Drug_concept_id Condition_concept_id;
	run;
%let pairs_ind=1;

proc sort data=&DATAWRK..pairs_of_interest NODUPKEY;
by Drug_concept_id Condition_concept_id;
run;
%end;
%else %do;  %let pairs_ind=0;   %end;

 %if (&VIS=1) %then %do;
proc sort data=&DATAIN..visit_occurrence out=&DATAWRK..visit_occurrence1 (keep=Person_id visit_start_date) NODUPKEY THREADS;
	by Person_id visit_start_date;
	run;
                    %end;

%if &ind_ind=1 %then %do;

/* people that satisfy the criteria */
proc sql THREADS;
create table &DATAWRK..Conditions_people as
select DISTINCT T1.Person_id
from &DATAIN..&Condition_era_table T1, &DATAWRK..indications_cond_uni T2
where T1.Condition_concept_id=T2.Condition_concept_id
/*AND T1.Condition_occurrence_type = &PWC*/
order by T1.Person_id;

create table &DATAWRK..Condition_era as
select DISTINCT T1.Person_id, T1.Condition_concept_id, MIN(T1.Condition_era_start_date) AS Index_date format DATE9.
from &DATAIN..&Condition_era_table T1, &DATAWRK..Conditions_people T2, &DATAIN..Observation_period T3
where T1.Person_id=T2.Person_id
AND T1.Person_id=T3.Person_id
AND T3.Observation_period_start_date + &DAYS_ENROLLED <= T1.Condition_era_start_date
AND T1.Condition_era_start_date <= T3.Observation_period_end_date
group by T1.Person_id, T1.Condition_concept_id;

create table &DATAWRK..Indi_people as
select DISTINCT T1.Person_id
from &DATAWRK..Condition_era T1;

create table &DATAWRK..Indi_people_with_cond as
select DISTINCT T1.Person_id, T1.Condition_concept_id
from &DATAWRK..Condition_era T1
order by T1.Person_id, T1.Condition_concept_id;

create table &DATAWRK..Drug_era as 
select T1.Person_id, T1.Drug_concept_id, T1.Drug_era_start_date,
T1.Drug_era_end_date 
from &DATAIN..&Drug_era_table  T1, &DATAWRK..Indi_people T2
where T1.Person_id = T2.Person_id
/*AND T1.Drug_Exposure_Type = &PWD*/;

%if &drug_oc=1 %then %do;
create table &DATAWRK..Drug_era as
select DISTINCT T1.Person_id, T1.Drug_concept_id, min(T1.Drug_era_start_date) as Drug_era_start_date, min(T1.Drug_era_end_date) as Drug_era_end_date
from &DATAWRK..Drug_era T1
group by T1.Person_id, T1.Drug_concept_id;
%end;

create table &DATAWRK..Person as
select T1.Person_id, T1.Year_of_birth,  T1.Gender_concept_id 
from &DATAIN..Person T1, &DATAWRK..Indi_people T2
where T1.Person_id = T2.Person_id;

create table &DATAWRK..Observation_period as
select T1.Person_id, T1.Observation_period_start_date,  T1.Observation_period_end_date 
from &DATAIN..Observation_period T1, &DATAWRK..Indi_people T2
where T1.Person_id = T2.Person_id;
quit;


%end; /* ind_ind */

%if &ind_ind=0 %then %do;
/*******************************************************************
*   preprocess input data, Condition_era                           * 
*******************************************************************/
proc sort data=&DATAIN..&Condition_era_table (/*where=(Condition_occurrence_type = &PWC)*/ 
keep = Person_id Condition_era_start_date Condition_concept_id /*Condition_occurrence_type*/) 
out=&DATAWRK..Condition_era  /*(drop=Condition_occurrence_type)*/ NODUPKEY THREADS;
by Person_id Condition_concept_id Condition_era_start_date;
where Condition_concept_id NE .;
run;

/*******************************************************************
*   preprocess input data, Drug_era                                * 
*******************************************************************/

proc sort data=&DATAIN..&Drug_era_table (/*where=(Drug_Exposure_Type = &PWD)*/ 
keep=Person_id Drug_era_start_date Drug_era_end_date Drug_concept_id /*Drug_Exposure_Type*/) 
out=&DATAWRK..Drug_era /*(drop=Drug_Exposure_Type)*/ NODUPKEY THREADS;
by Person_id Drug_concept_id Drug_era_start_date Drug_era_end_date;
where Drug_concept_id NE .;
run;

%if &drug_oc=1 %then %do;
proc sql THREADS;
create table &DATAWRK..Drug_era as
select DISTINCT T1.Person_id, T1.Drug_concept_id, min(T1.Drug_era_start_date) as Drug_era_start_date, min(T1.Drug_era_end_date) as Drug_era_end_date
from &DATAWRK..Drug_era T1
group by T1.Person_id, T1.Drug_concept_id;
quit; 
%end;
/*******************************************************************
*   preprocess input data, Person data                             * 
*******************************************************************/
proc sort data=&DATAIN..Person out=&DATAWRK..Person 
(keep=Person_id Year_of_birth Gender_concept_id) THREADS;
by Person_id;
where (Person_id NE .) AND (Gender_concept_id NE .) AND (Year_of_birth NE .);
run;

/*******************************************************************
*   preprocess input data, Observation_period data                 * 
*******************************************************************/
proc sort data=&DATAIN..Observation_period out=&DATAWRK..Observation_period THREADS;
by Person_id;
run;

%end; /* ind_ind=0 */

/* create sex-age groups */
proc sort data=&DATAWRK..Person out=&DATAWRK.._As_groups (keep=Gender_concept_id Year_of_birth) NODUPKEY THREADS;
by Gender_concept_id Year_of_birth;
run;

data &DATAWRK.._As_groups;
set &DATAWRK.._As_groups;
y=round(Year_of_birth/10);
run;

proc sort data=&DATAWRK.._As_groups out=&DATAWRK.._As_groups1 (keep=Gender_concept_id Y) NODUPKEY THREADS;
by Gender_concept_id Y;
run;

data &DATAWRK.._As_groups1;
set &DATAWRK.._As_groups1;
group=_n_;
run;

proc sort data=&DATAWRK.._As_groups;
by Gender_concept_id Y;
run;

data &DATAWRK.._As_groups (drop=y);
merge &DATAWRK.._As_groups &DATAWRK.._As_groups1;
by Gender_concept_id Y;
run;

proc sort data=&DATAWRK.._As_groups THREADS;
by Gender_concept_id Year_of_birth;
run; 

proc sort data=&DATAWRK..Person THREADS;
by Gender_concept_id Year_of_birth;
run; 

data &DATAWRK.._Person_groups (keep=Person_id Group) ;
merge &DATAWRK..Person &DATAWRK.._As_groups;
by 	Gender_concept_id Year_of_birth;
run;

proc sort data=&DATAWRK.._Person_groups THREADS;
by Person_id;
run;

proc sort data=&DATAWRK..Condition_era THREADS;
by Person_id;
run;

data &DATAWRK..Condition_era;
merge &DATAWRK..Condition_era (IN=SET1) &DATAWRK.._Person_groups (IN=SET2);
by Person_id;
if SET1 AND SET2;
run; 

/*******************************************************************
*  Output pairs                                                    * 
*******************************************************************/

%if %sysfunc(fileexist(&drugs_of_interest)) %then 
%do; %put drugs_of_interest.txt file exists;

	data &DATAWRK..Drugs_of_interest;
	infile "&drugs_of_interest" firstobs=2;
	input Drug_concept_id;
	run;

	proc sort data=&DATAWRK..Drugs_of_interest NODUPKEY;
	by Drug_concept_id;
	run;

	%let dr_ind=1;
%end;
%else %do; %put drugs_of_interest.txt does not exist; %let dr_ind=0; %end;

%if %sysfunc(fileexist(&conditions_of_interest)) %then 
%do; %put conditions_of_interest.txt file exists;
	data &DATAWRK..Conditions_of_interest;
	infile "&conditions_of_interest" firstobs=2;
	input Condition_concept_id;
	run;
	
	proc sort data=&DATAWRK..Conditions_of_interest NODUPKEY;
	by Condition_concept_id;
	run;

	%let cnd_ind=1;
%end;
%else %do; %put conditions_of_interest.txt does not exist; %let cnd_ind=0; %end;


%if &dr_ind=1 %then %do;
	proc sort data=&DATAWRK..Drug_ERA;
	by Drug_concept_id;
	run;

	data &DATAWRK..Drug_ERA;
	merge &DATAWRK..Drug_ERA (IN=SET1) &DATAWRK..Drugs_of_interest (IN=SET2);
	by Drug_concept_id;
	if SET1 AND SET2;
    run;
  
	proc sort data=&DATAWRK..Drug_ERA;
	by Person_id;
	run;
%end;

%if &s_window <0 %then
%do;
    %put 'window negative';  
	data &DATAWRK..drugs;
	set &DATAWRK..drug_era;
	drug_era_end_date=drug_era_start_date - &s_window;
	keep person_id drug_concept_id drug_era_start_date drug_era_end_date;
	run;
%end;

%if &s_window > 0 %then
%do;
    %put 'window positive';  
	data &DATAWRK..drugs;
	set &DATAWRK..drug_era;
	drug_era_end_date=drug_era_end_date + &s_window;
	keep person_id drug_concept_id drug_era_start_date drug_era_end_date;
	run;
%end;

%if &s_window ^= 0 %then
%do;

proc sort data=&DATAWRK..drugs;
by person_id drug_concept_id drug_era_start_date;
run;


data &DATAWRK..drugs2;

retain end_date  -10000000000000000000000000000000;
retain start_date 10000000000000000000000000000000;
retain did 0;
retain person 0;

set &DATAWRK..drugs;

if person NE person_id then person=0;
if did NE drug_concept_id then did =0;

if (did EQ 0) OR (person=0) then do; did=drug_concept_id; person=person_id; 
end_date=-10000000000000000000000000000000;
start_date=10000000000000000000000000000000; end;

if end_date < drug_era_start_date then do; end_date=drug_era_end_date; start_date=drug_era_start_date; end;
if end_date >=start_date then do; drug_era_start_date=start_date; end_date=drug_era_end_date; end;
length=drug_era_end_date-drug_era_start_date;

run; 

proc sort data=&DATAWRK..drugs2;
by person_id drug_concept_id DESCENDING length drug_era_start_date;
run;

proc sort data=&DATAWRK..drugs2;
by person_id drug_concept_id drug_era_start_date;
run;

proc sort data=&DATAWRK..drugs2 out=&DATAWRK..drug_era (keep= person_id drug_concept_id drug_era_start_date drug_era_end_date) NODUPKEY;
by person_id drug_concept_id drug_era_start_date;
run;

%if &del_interm=1 %then %do;
proc datasets lib=&DATAWRK NOLIST NOWARN;
delete drugs drugs2;
run; %end;
%end;

/* END DRUG_ERA UPDATE */
data &DATAWRK..Drug_ERA;
 merge &DATAWRK..Drug_ERA (IN=SET1) &DATAWRK.._Person_groups (IN=SET2);
by Person_id;
if SET1 AND SET2;
run; 


%if &ind_ind=1 %then %do; /* nest */

proc sql THREADS;
create table &DATAWRK..people_with_drugs as
select DISTINCT T1.Person_id, T1.Drug_concept_id 
from &DATAWRK..Drug_ERA T1;

create table &DATAWRK..people_with_conds as
select DISTINCT T1.Person_id, T1.Condition_concept_id 
from &DATAWRK..Condition_era T1, &DATAWRK..Conditions_of_interest T2 
where T1.Condition_concept_id = T2.Condition_concept_id;

create table &DATAWRK..drugs_conds_pairs as
select DISTINCT T1.Drug_concept_id, T2.Condition_concept_id
from &DATAWRK..people_with_drugs T1, &DATAWRK..people_with_conds T2
where T1.Person_id = T2.Person_id
order by T1.Drug_concept_id, T2.Condition_concept_id; 
quit;


%if &pairs_ind=1 %then %do;
data &DATAWRK..drugs_conds_pairs;
merge &DATAWRK..drugs_conds_pairs (IN=SET1) 
&DATAWRK..pairs_of_interest (IN=SET2);
by Drug_concept_id Condition_concept_id;
if SET1 AND SET2;
run;
%end;

proc sql THREADS;
create table &DATAWRK..drugs_loop as 
select DISTINCT T1.Drug_concept_id 
from &DATAWRK..drugs_conds_pairs T1;
quit;

proc sort data= &DATAWRK..Condition_era;
by Person_id;
run;

proc sort data= &DATAWRK..Drug_era;
by Person_id;
run;

proc sort data= &DATAWRK..Observation_period;
by Person_id;
run;

proc sort data= &DATAWRK..Person;
by Person_id;
run;


proc sort data=&DATAWRK..Indications NODUPKEY;
by Drug_concept_id Condition_concept_id;
run;


data &DATAWRK.._null_;
set &DATAWRK..drugs_loop;
i+1;
ii=left(put(i, 10.));
call symput('DRGS'||ii,Drug_concept_id);
call symput('TOT_DRGS',ii);
run;

%let bynum=&num_part;
options autosignon=yes;
%do j=1 %to &bynum;

signon tsk&j sascmd="&SAS_PROGRAM";

%syslput j=&j;
%syslput num_part=&num_part;
%syslput DATAWRK=&DATAWRK;
%syslput TOT_DRGS=&TOT_DRGS;
%syslput WRKFOLDER=&wrkfolder;
%syslput NUM_PASSES=&num_passes;
%syslput NUM_MATCHES=&num_matches;
%syslput DAYS_ENROLLED=&days_enrolled;
%syslput DEL_INTERM=&del_interm;
%syslput B_DAYS=&B_days;
%syslput VIS=&vis;
%syslput BYNUM=&bynum;
%syslput VDW=&vdw;


rsubmit tsk&j wait=no log="&wrkfolder./tsk&j..txt";
LIBNAME WRK "&WRKFOLDER";
options CPUCOUNT=ACTUAL THREADS;

data &DATAWRK.._null_;
set &DATAWRK..drugs_loop;
i+1;
ii=left(put(i, 10.));
call symput('DRGS'||ii,Drug_concept_id);
run;


%nrstr(%%)let MN=&J;

%do M=&J %to &TOT_DRGS %by &BYNUM;

%nrstr(%%)put 'MN=' &MN;
%nrstr(%%)let cur_d=&&DRGS&MN;

data &DATAWRK..Conds_Indi_&MN (keep=Condition_concept_id);
set &DATAWRK..Indications;
where Drug_concept_id = &cur_d;
run;


data &DATAWRK..Conds_set_&MN (keep=Condition_concept_id);
set &DATAWRK..Drugs_conds_pairs;
where Drug_concept_id = &cur_d;
run;

proc sort data=&DATAWRK..Conds_Indi_&MN;
by Condition_concept_id;
run;

proc sql THREADS;
create table &DATAWRK..people_for_&MN as
select DISTINCT T1.Person_id
from  &DATAWRK..Indi_people_with_cond T1, &DATAWRK..Conds_Indi_&MN T2
where T1.Condition_concept_id=T2.Condition_concept_id
order by T1.Person_id;
quit;

data &DATAWRK..Condition_era_&MN &DATAWRK..Condition_era_S_&MN;
merge &DATAWRK..Condition_era (IN=SET1) &DATAWRK..people_for_&MN (IN=SET2);
by Person_id;
if SET1 AND SET2;
run;

data &DATAWRK..Drug_era_&MN (where=(Drug_concept_id EQ &cur_d));
merge &DATAWRK..Drug_era (IN=SET1) &DATAWRK..people_for_&MN (IN=SET2);
by Person_id;
if SET1 AND SET2;
run;

/* delete file(s) that is not in use */
    %if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_a_&MN;
    quit;
	run;
	%end;
/* create index pool */

    %if &cnd_ind=1 %then %do;
	proc sql;
	create table &DATAWRK.._Index_pool_&MN as
    select DISTINCT T1.Condition_concept_id, T1.Group, T1.Index_date
	from &DATAWRK..Condition_era_&MN T1, &DATAWRK..Conds_set_&MN T2
	where T1.Condition_concept_id=T2.Condition_concept_id
	order by T1.Group, T1.Condition_concept_id, T1.Index_date;
    quit; 
	%end;

	%else 

	%do;
	proc sort data=&DATAWRK..Condition_era_&MN 
    out=&DATAWRK.._Index_pool_&MN (keep=Condition_concept_id Group Index_date) NODUPKEY THREADS;
    by Group Condition_concept_id Index_date;
    run;  
	%end;

    %if (&VIS=0) %then %do;
	data &DATAWRK.._Controlpool_&MN;
	merge &DATAWRK..People_for_&MN (IN=SET1) &DATAWRK..Observation_period (IN=SET2);
	by Person_id;
	if SET1 AND SET2;
	randi0=ranuni(123);
	run;

   data &DATAWRK.._Controlpool_&MN;
   merge &DATAWRK.._Controlpool_&MN (IN=SET1) &DATAWRK.._person_groups (IN=SET2);
   by Person_id;
   if SET1 AND SET2;
   run;
	%end;

	%if (&VIS=1) %then %do; 
	proc sql THREADS;
    create table &DATAWRK.._Person_groups2_&MN as
    SELECT	DISTINCT T1.Person_id, T3.Group, T2.visit_start_date
    FROM &DATAWRK..People_for_&MN T1, &DATAWRK..Visit_occurrence1 T2, &DATAWRK.._person_groups T3
	where T1.Person_id=T2.Person_id
	AND T1.Person_id=T3.Person_id
	order by T1.Person_id, T3.Group, T2.visit_start_date;
    quit;
  
	data &DATAWRK.._Controlpool_&MN;
	set &DATAWRK.._Person_groups2_&MN;
	randi0=ranuni(123);
	run;
	%end;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Person_groups_&MN _Person_groups2_&MN;
    quit;
	run;
	%end;

	proc sort data=	&DATAWRK.._Controlpool_&MN out=&DATAWRK.._Controlpool_&MN (drop=randi0) THREADS;
	by Group randi0;
	run;
/* create pointers to groups in the controlpool file(s) */
	data &DATAWRK.._groups_begin_end_&MN (keep=group r_start r_end);
    label group = 'group';
    retain r_start;
    set &DATAWRK.._Controlpool_&MN;
    by group;
    if first.group=1 then do; r_start=_n_; end;
    if last.group=1 then do; r_end=_n_; output; end;
    run;

    data &DATAWRK.._index_pool_&MN; *(drop=group); 
	merge &DATAWRK.._index_pool_&MN (IN=SET1) &DATAWRK.._groups_begin_end_&MN;
	by group;
	if SET1;
	*rnum=ranuni(0);
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _groups_begin_end_&MN;
    quit;
	run;
	%end;

/* select controls */
%if &VIS=0 %then %do; 
 	data &DATAWRK.._Controls_&MN (keep=Condition_concept_id Index_date Person_id Group randi);
 	set &DATAWRK.._Index_pool_&MN;
 	found=0;
	  do i=1 to &NUM_PASSES until(found>= &NUM_MATCHES);
	   x1=ceil(r_start + ranuni(0)*(r_end - r_start));
	   x2=ceil(r_start + ranuni(0)*(r_end - r_start));
 		  s1=min(x1,x2); s2=max(x1,x2);
      do j=s1 to s2 until(found>= &NUM_MATCHES);
    	set &DATAWRK.._Controlpool_&MN point=j;
	   		if (Observation_period_start_date + &DAYS_ENROLLED) <= Index_date <= Observation_period_end_date then
         	do; 
		   		randi=ranuni(0);
           		found=found+1; 
		   		output;
		 		end;
	  		end;
  		end; 
	run;
%end;


%if &VIS=1 %then 
	%do; 
/* select controls */
 	data &DATAWRK.._Controls_&MN (keep=Condition_concept_id visit_start_date /*Index_date*/ Person_id Group randi rename=(visit_start_date=Index_date));
 	set &DATAWRK.._Index_pool_&MN;
 	found=0;
	  do i=1 to &NUM_PASSES until(found>= &NUM_MATCHES);
	   x1=ceil(r_start + ranuni(0)*(r_end - r_start));
	   x2=ceil(r_start + ranuni(0)*(r_end - r_start));
 		  s1=min(x1,x2); s2=max(x1,x2);
      do j=s1 to s2 until(found>= &NUM_MATCHES);
    	set &DATAWRK.._Controlpool_&MN point=j;
	   		if  Index_date- &VDW <= visit_start_date <= Index_date + &VDW then
         	do; 
		   		randi=ranuni(0);
           		found=found+1; 
		   		output;
		 		end;
	  		end;
  		end; 
	run;
%end;



	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controlpool_&MN _Index_pool_&MN;
    quit;
	run;
	%end;

/* sort according randi - to randomize order of index_dates for each person */
	proc sort data=&DATAWRK.._Controls_&MN THREADS;
	by condition_concept_id person_id randi;
	run;

/* delete duplicates in the controls set */
	proc sort data=&DATAWRK.._Controls_&MN out=&DATAWRK.._Controls_nodup_&MN (drop=randi) NODUPKEYS THREADS;
	by condition_concept_id person_id;
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_&MN;
    quit;
	run;
	%end;

/* remove case people from the controls, create _Controls_fin_&i */
	proc sort data=&DATAWRK..Condition_era_&MN THREADS;
	by condition_concept_id person_id;
	run;


	%if &cnd_ind=1 %then %do;
	data &DATAWRK..Condition_era_&MN;
	merge &DATAWRK..Condition_era_&MN (IN=SET1) &DATAWRK..conds_set_&MN (IN=SET2);
	by Condition_concept_id;
	if SET1 AND SET2;
	run;
	%end;


    proc sql THREADS;
	create table &DATAWRK..ind_date_&MN as
	select T1.Person_id, min(T1.Index_date) as ind_date
    from  &DATAWRK..Condition_era_s_&MN T1, &DATAWRK..Conds_indi_&MN T2
	where T1.Condition_concept_id = T2.Condition_concept_id
	group by T1.Person_id;

	create table &DATAWRK..Condition_era_&MN as
	select T1.Person_id, T1.Condition_concept_id, T1.Index_date, T1.group 
    from &DATAWRK..Condition_era_&MN T1, &DATAWRK..ind_date_&MN T2
	where T1.Person_id = T2.Person_id
	AND T1.Index_date >= T2.ind_date
	order by T1.Condition_concept_id, T1.Person_id; 
    quit;

	data &DATAWRK.._Controls_fin_&MN;
	merge &DATAWRK.._Controls_nodup_&MN &DATAWRK..Condition_era_&MN (IN=SET2);
	by condition_concept_id person_id;
	if NOT SET2;
	run; 
 
	proc sql THREADS;
    create table &DATAWRK.._Controls_fin_&MN as
	select T1.Person_id, T1.Condition_concept_id, T1.Index_date, T1.group 
    from &DATAWRK.._Controls_fin_&MN T1, &DATAWRK..ind_date_&MN T2
	where T1.Person_id = T2.Person_id
	AND T1.Index_date >= T2.ind_date;
    quit;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_nodup_&MN _Cases_delete_&MN;
    quit;
	run;
	%end;
/* controls exposure to drugs */
	proc sql THREADS;
	create table &DATAWRK.._Controls_drugs_conditions_&MN as
	SELECT 	DISTINCT T1.Person_id,
	        T1.Condition_concept_id,
            T2.Drug_concept_id,
            T1.index_date,
            T1.group            
	FROM &DATAWRK.._Controls_fin_&MN T1,
		&DATAWRK..Drug_era_&MN T2
			where T1.Person_id = T2.Person_id
	AND T1.Index_date >= T2.Drug_era_start_date + &B_DAYS
		  AND T1.Index_date <= T2.Drug_era_end_date
	ORDER BY T1.Person_id, T1.index_date, T2.Drug_concept_id;
	quit;

	proc sql THREADS;
	create table &DATAWRK.._Controls_counts_by_drugs_&MN as
	SELECT T1.Condition_concept_id, T1.Drug_concept_id, T1.group, count(T1.Person_id) as Exposed_controls
	FROM &DATAWRK.._Controls_drugs_conditions_&MN T1
	group by T1.Condition_concept_id, T1.Drug_concept_id, T1.group;
	run;

	%if  ((&DEL_INTERM=1) AND (&RLR=0)) %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_drugs_conditions_&MN;
    quit; 
	run;
	%end;

	proc sql THREADS;
	create table &DATAWRK.._Controls_counts_all_&MN as
	SELECT T1.Condition_concept_id, T1.group, count(T1.PERSON_ID) as TOTAL_CONTROLS
	FROM &DATAWRK.._controls_fin_&MN T1
	group by T1.Condition_concept_id, T1.group;
	quit;

	%if  ((&DEL_INTERM=1) AND (&RLR=0)) %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_fin_&MN;
    quit;
	run;
	%end;

/* cases exposure to drugs */
	proc sql THREADS;
	create table &DATAWRK.._Cases_drugs_conditions_&MN as
	SELECT 	DISTINCT T1.Person_id,
	        T1.Condition_concept_id,
            T2.Drug_concept_id,
            T1.index_date,
            T1.group            
	FROM &DATAWRK..Condition_era_&MN T1,
		&DATAWRK..Drug_era_&MN T2
			where T1.Person_id = T2.Person_id
	AND T1.Index_date >= T2.Drug_era_start_date +&B_DAYS
		  AND T1.Index_date <= T2.Drug_era_end_date
	ORDER BY T1.Person_id, T1.index_date, T2.Drug_concept_id;
	quit;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete Drug_era_&MN;
    quit;
	run;
	%end;

	proc sql THREADS;
	create table &DATAWRK.._Cases_counts_by_drugs_&MN as
	SELECT T1.Condition_concept_id, T1.Drug_concept_id, T1.group, count(T1.Person_id) as Exposed_cases
	FROM &DATAWRK.._Cases_drugs_conditions_&MN T1
	group by T1.Condition_concept_id, T1.Drug_concept_id, T1.group;
	run;

	%if  ((&DEL_INTERM=1) AND (&RLR=0)) %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_drugs_conditions_&MN;
    quit;
	run;
	%end;

	proc sql THREADS;
	create table &DATAWRK.._Cases_counts_all_&MN as
	SELECT T1.Condition_concept_id, T1.group, count(T1.Person_id) as TOTAL_CASES
	FROM &DATAWRK..Condition_era_&MN T1
	group by T1.Condition_concept_id, T1.group;
	quit;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_&MN;
    quit;
	run;
	%end;

	proc sort data=&DATAWRK.._Cases_counts_by_drugs_&MN
	out=&DATAWRK.._Cases_drugs_info_&MN (keep=Condition_concept_id Drug_concept_id) NODUPKEY THREADS;
	by Condition_concept_id Drug_concept_id;
	run;

    data &DATAWRK.._Cases_groups_drugs_&MN;
	set &DATAWRK.._Cases_counts_all_&MN;
	Drug_concept_id=&cur_d;
	run;	 

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_counts_all_&MN _Cases_drugs_info_&MN;
    quit;
	run;
	%end;

	proc sort data=&DATAWRK.._Cases_counts_by_drugs_&MN THREADS;
	by Condition_concept_id Group Drug_concept_id;
	run;

	data &DATAWRK.._Cases_summary_&MN;
	merge &DATAWRK.._Cases_counts_by_drugs_&MN &DATAWRK.._Cases_groups_drugs_&MN ;
	by Condition_concept_id Group Drug_concept_id;
	if Exposed_cases EQ . then Exposed_cases=0; 
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_counts_by_drugs_&MN _Cases_groups_drugs_&MN;
    quit;
	run;
	%end;

	proc sort data=&DATAWRK.._Cases_summary_&MN THREADS;
	by Condition_concept_id Group;
	run;

	proc sort data= &DATAWRK.._Controls_counts_all_&MN THREADS;
	by Condition_concept_id Group;
	run;

	data &DATAWRK.._Summary_&MN;
	merge &DATAWRK.._Cases_summary_&MN (IN=SET1) &DATAWRK.._Controls_counts_all_&MN (IN=SET2);
	by Condition_concept_id Group;
	if SET1 AND SET2;
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_summary_&MN _Controls_counts_all_&MN;
    quit;
	run;
	%end;

	proc sort data= &DATAWRK.._Controls_counts_by_drugs_&MN THREADS;
	by Condition_concept_id Group Drug_concept_id;
	run;
	
	data  &DATAWRK.._Summary_&MN;
	merge &DATAWRK.._Summary_&MN (IN=SET1) &DATAWRK.._Controls_counts_by_drugs_&MN;
	by Condition_concept_id Group Drug_concept_id;
	if Exposed_controls EQ . then Exposed_controls=0;
	if (Exposed_cases EQ 0) AND (Exposed_controls EQ 0) then delete; 
	if SET1;
	T=Exposed_cases*(Total_controls - Exposed_controls)/(Total_cases+Total_controls);
	B=Exposed_controls*(Total_cases - Exposed_cases)/(Total_cases+Total_controls);
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete 
    %if &RLR=0 %then %do; Condition_era_&MN %end;
	Condition_era_s_&MN
	Conds_indi_&MN
	Conds_set_&MN
	Ind_date_&MN
	People_for_&MN 
	_Controls_counts_by_drugs_&MN
	;
    quit;
	run;
	%end;

%nrstr(%%)let MN=%eval(&MN+&BYNUM);

%end;

endrsubmit;
%end;

waitfor _all_ %do k=1 %to &bynum; tsk&k %end;;
signoff _all_;


data &DATAWRK.._Summary_;
set %do i=1 %to &TOT_DRGS; &DATAWRK.._Summary_&i  %end;
;
run;


%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete 
    %do i=1 %to &TOT_DRGS; _Summary_&i  %end;
	;
    quit;
	run;
	%end;

%end; /*nest */

%if &ind_ind=0 %then %do;

/* TOT_GRP macro =total # of groups */
data _null_;
set &DATAWRK.._As_groups;
i+1;
ii=left(put(i, 5.));
call symput('TOT_GRP',ii);
run;

/* split into parts */
options autosignon=yes;

%do i=1 %to &num_part;

signon tsk&i sascmd="&SAS_PROGRAM";
%syslput i=&i;
%syslput num_part=&num_part;
%syslput DATAWRK=&DATAWRK;
%syslput TOT_GRP=&TOT_GRP;
%syslput WRKFOLDER=&wrkfolder;
%syslput NUM_PASSES=&num_passes;
%syslput NUM_MATCHES=&num_matches;
%syslput DAYS_ENROLLED=&days_enrolled;
%syslput DEL_INTERM=&del_interm;
%syslput B_DAYS=&B_days;
%syslput VIS=&vis;
%syslput VDW=&vdw;
%syslput RLR=&RLR;
%syslput BLR=&blr;

rsubmit tsk&i wait=no log="&wrkfolder./tsk&i..txt";
LIBNAME WRK "&WRKFOLDER";
options CPUCOUNT=ACTUAL THREADS;
options compress=yes;
/* split Condition_era file */
    data &DATAWRK..Condition_era_&i;
    set &DATAWRK..Condition_era;
    where %if &i < &num_part %then %do;( group GT %eval((&TOT_GRP/&num_part)*(&i-1)))
           AND ( group LE %eval((&TOT_GRP/&num_part)*(&i))); %end;
		   %else
		   %do;
           ( group GT %eval((&TOT_GRP/&num_part)*(&i-1)));
		   %end;
    run;
/* split Drug_era file */
	data &DATAWRK..Drug_era_&i;
    set &DATAWRK..Drug_era;
    where %if &i < &num_part %then %do;( group GT %eval((&TOT_GRP/&num_part)*(&i-1)))
           AND ( group LE %eval((&TOT_GRP/&num_part)*(&i))); %end;
		   %else
		   %do;
           ( group GT %eval((&TOT_GRP/&num_part)*(&i-1)));
		   %end;
    run;

	proc sql THREADS;
    create table &DATAWRK.._Cases_&i as
    SELECT	T1.Person_id, T1.Condition_concept_id, T1.Group, MIN(T1.Condition_era_start_date) AS Index_date format DATE9.
    FROM &DATAWRK..Condition_era_&i T1, &DATAWRK..Observation_period T2 
    WHERE T1.Person_id=T2.Person_id
		 AND T2.Observation_period_start_date + &DAYS_ENROLLED <= T1.Condition_era_start_date  
		   AND T1.Condition_era_start_date <= T2.Observation_period_end_date 
    GROUP BY T1.Person_id, T1.Condition_concept_id, T1.Group;
    quit;

 /* delete file(s) that is not in use */
    %if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete 
    %if &RLR=0 %then %do; Condition_era_&i %end; 
    _Cases_a_&i;
    quit;
	run;
	%end;
/* create index pool */

    %if &cnd_ind=1 %then %do;
	proc sql;
	create table &DATAWRK.._Index_pool_&i as
    select DISTINCT T1.Condition_concept_id, T1.Group, T1.Index_date
	from &DATAWRK.._Cases_&i T1, &DATAWRK..Conditions_of_interest T2
	where T1.Condition_concept_id=T2.Condition_concept_id
	order by T1.Group, T1.Condition_concept_id, T1.Index_date;
    quit; 
	%end;

	%else 

	%do;
	proc sort data=&DATAWRK.._Cases_&i 
    out=&DATAWRK.._Index_pool_&i (keep=Condition_concept_id Group Index_date) NODUPKEY THREADS;
    by Group Condition_concept_id Index_date;
    run;  
	%end;

    data &DATAWRK.._Person_groups_&i;
    set &DATAWRK.._Person_groups;
     where %if &i < &num_part %then %do;( group GT %eval((&TOT_GRP/&num_part)*(&i-1)))
           AND ( group LE %eval((&TOT_GRP/&num_part)*(&i))); %end;
		   %else
		   %do;
           ( group GT %eval((&TOT_GRP/&num_part)*(&i-1)));
		   %end;
    run;

       %if (&VIS=0) %then %do;
	data &DATAWRK.._Controlpool_&i;
	merge &DATAWRK.._Person_groups_&i (IN=SET1) &DATAWRK..Observation_period (IN=SET2);
	by Person_id;
	if SET1 AND SET2;
	randi0=ranuni(123);
	run;
	%end;


	%if (&VIS=1) %then %do;
	
	proc sql THREADS;
    create table &DATAWRK.._Person_groups2_&i as
    SELECT	DISTINCT T1.Person_id, T1.Group, T2.visit_start_date
    FROM &DATAWRK.._Person_groups_&i T1, &DATAWRK..Visit_occurrence1 T2
	where T1.Person_id=T2.Person_id
	order by T1.Person_id, T1.Group, T2.visit_start_date;
    quit;
  
	data &DATAWRK.._Controlpool_&i;
	set &DATAWRK.._Person_groups2_&i;
	randi0=ranuni(123);
	run;

	%end;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Person_groups_&i _Person_groups2_&i;
    quit;
	run;
	%end;

	proc sort data=	&DATAWRK.._Controlpool_&i out=&DATAWRK.._Controlpool_&i (drop=randi0) THREADS;
	by Group randi0;
	run;
/* create pointers to groups in the controlpool file(s) */
	data &DATAWRK.._groups_begin_end_&i (keep=group r_start r_end);
    label group = 'group';
    retain r_start;
    set &DATAWRK.._Controlpool_&i;
    by group;
    if first.group=1 then do; r_start=_n_; end;
    if last.group=1 then do; r_end=_n_; output; end;
    run;

    data &DATAWRK.._index_pool_&i; *(drop=group); 
	merge &DATAWRK.._index_pool_&i (IN=SET1) &DATAWRK.._groups_begin_end_&i;
	by group;
	if SET1;
	*rnum=ranuni(0);
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _groups_begin_end_&i;
    quit;
	run;
	%end;
/* select controls */

%if &VIS=0 %then %do; 
 	data &DATAWRK.._Controls_&i (keep=Condition_concept_id Index_date Person_id Group randi);
 	set &DATAWRK.._Index_pool_&i;
 	found=0;
	  do i=1 to &NUM_PASSES until(found>= &NUM_MATCHES);
	   x1=ceil(r_start + ranuni(0)*(r_end - r_start));
	   x2=ceil(r_start + ranuni(0)*(r_end - r_start));
 		  s1=min(x1,x2); s2=max(x1,x2);
      do j=s1 to s2 until(found>= &NUM_MATCHES);
    	set &DATAWRK.._Controlpool_&i point=j;
	   		if (Observation_period_start_date + &DAYS_ENROLLED) <= Index_date <= Observation_period_end_date then
         	do; 
		   		randi=ranuni(0);
           		found=found+1; 
		   		output;
		 		end;
	  		end;
  		end; 
	run;
%end;

%if &VIS=1 %then 
	%do; 
/* select controls */
 	data &DATAWRK.._Controls_&i (keep=Condition_concept_id visit_start_date /*Index_date*/ Person_id Group randi rename=(visit_start_date=Index_date));
 	set &DATAWRK.._Index_pool_&i;
 	found=0;
	  do i=1 to &NUM_PASSES until(found>= &NUM_MATCHES);
	   x1=ceil(r_start + ranuni(0)*(r_end - r_start));
	   x2=ceil(r_start + ranuni(0)*(r_end - r_start));
 		  s1=min(x1,x2); s2=max(x1,x2);
      do j=s1 to s2 until(found>= &NUM_MATCHES);
    	set &DATAWRK.._Controlpool_&i point=j;
	   		if  Index_date- &VDW <= visit_start_date <= Index_date + &VDW then
         	do; 
		   		randi=ranuni(0);
           		found=found+1; 
		   		output;
		 		end;
	  		end;
  		end; 
	run;
%end;



	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controlpool_&i _Index_pool_&i;
    quit;
	run;
	%end;

/* sort according randi - to randomize order of index_dates for each person */
	proc sort data=&DATAWRK.._Controls_&i THREADS;
	by condition_concept_id person_id randi;
	run;

/* delete duplicates in the controls set */
	proc sort data=&DATAWRK.._Controls_&i out=&DATAWRK.._Controls_nodup_&i (drop=randi) NODUPKEYS THREADS;
	by condition_concept_id person_id;
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_&i;
    quit;
	run;
	%end;

	proc sort data=&DATAWRK.._Cases_&i THREADS;
	by condition_concept_id person_id;
	run;

	%if &cnd_ind=1 %then %do;
	data &DATAWRK.._Cases_&i;
	merge &DATAWRK.._Cases_&i (IN=SET1) &DATAWRK..conditions_of_interest (IN=SET2);
	by Condition_concept_id;
	if SET1 AND SET2;
	run;
	%end;

	data &DATAWRK.._Controls_fin_&i;
	merge &DATAWRK.._Controls_nodup_&i &DATAWRK.._Cases_&i (IN=SET2);
	by condition_concept_id person_id;
	if NOT SET2;
	run; 

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_nodup_&i _Cases_delete_&i;
    quit;
	run;
	%end;
/* controls exposure to drugs */
	proc sql THREADS;
	create table &DATAWRK.._Controls_drugs_conditions_&i as
	SELECT 	DISTINCT T1.Person_id,
	        T1.Condition_concept_id,
            T2.Drug_concept_id,
            T1.index_date,
            T1.group            
	FROM &DATAWRK.._Controls_fin_&i T1,
		&DATAWRK..Drug_era_&i T2
			where T1.Person_id = T2.Person_id
	AND T1.Index_date >= T2.Drug_era_start_date + &B_DAYS
		  AND T1.Index_date <= T2.Drug_era_end_date
	ORDER BY T1.Person_id, T1.index_date, T2.Drug_concept_id;
	quit;

	proc sql THREADS;
	create table &DATAWRK.._Controls_counts_by_drugs_&i as
	SELECT T1.Condition_concept_id, T1.Drug_concept_id, T1.group, count(T1.Person_id) as Exposed_controls
	FROM &DATAWRK.._Controls_drugs_conditions_&i T1
	group by T1.Condition_concept_id, T1.Drug_concept_id, T1.group;
	run;

	%if &RLR=0 %then %do;
	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_drugs_conditions_&i;
    quit; 
	run;
	%end;
	%end;

	proc sql THREADS;
	create table &DATAWRK.._Controls_counts_all_&i as
	SELECT T1.Condition_concept_id, T1.group, count(T1.PERSON_ID) as TOTAL_CONTROLS
	FROM &DATAWRK.._controls_fin_&i T1
	group by T1.Condition_concept_id, T1.group;
	quit;

	%if  (&DEL_INTERM=1)&&(&RLR=0) %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_fin_&i;
    quit;
	run;
	%end;

/* cases exposure to drugs */
	proc sql THREADS;
	create table &DATAWRK.._Cases_drugs_conditions_&i as
	SELECT 	DISTINCT T1.Person_id,
	        T1.Condition_concept_id,
            T2.Drug_concept_id,
            T1.index_date,
            T1.group            
	FROM &DATAWRK.._Cases_&i T1,
		&DATAWRK..Drug_era_&i T2
			where T1.Person_id = T2.Person_id
	AND T1.Index_date >= T2.Drug_era_start_date +&B_DAYS
		  AND T1.Index_date <= T2.Drug_era_end_date
	ORDER BY T1.Person_id, T1.index_date, T2.Drug_concept_id;
	quit;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete Drug_era_&i;
    quit;
	run;
	%end;

	proc sql THREADS;
	create table &DATAWRK.._Cases_counts_by_drugs_&i as
	SELECT T1.Condition_concept_id, T1.Drug_concept_id, T1.group, count(T1.Person_id) as Exposed_cases
	FROM &DATAWRK.._Cases_drugs_conditions_&i T1
	group by T1.Condition_concept_id, T1.Drug_concept_id, T1.group;

	run;

	%if &RLR=0 %then %do;
	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_drugs_conditions_&i;
    quit;
	run;
	%end;
	%end;

	proc sql THREADS;
	create table &DATAWRK.._Cases_counts_all_&i as
	SELECT T1.Condition_concept_id, T1.group, count(T1.Person_id) as TOTAL_CASES
	FROM &DATAWRK.._Cases_&i T1
	group by T1.Condition_concept_id, T1.group;
	quit;

	%if &RLR=0 %then %do;
	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_&i;
    quit;
	run;
	%end;
	%end;

	proc sort data=&DATAWRK.._Cases_counts_by_drugs_&i
	out=&DATAWRK.._Cases_drugs_info_&i (keep=Condition_concept_id Drug_concept_id) NODUPKEY THREADS;
	by Condition_concept_id Drug_concept_id;
	run;

endrsubmit;
%end;

waitfor _all_ %do i=1 %to &num_part; tsk&i %end;;

%do i=1 %to &num_part;
signoff tsk&i;
%end;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete Condition_era Drug_era Observation_period Person _Person_groups;
    quit;
	run;
	%end;

/*	for summary data, all drugs for each case set */
data &DATAWRK.._Cases_drugs_info_;
set %do i=1 %to &num_part; &DATAWRK.._Cases_drugs_info_&i  %end;
;
run;

proc sort data= &DATAWRK.._Cases_drugs_info_ NODUPKEY THREADS;
by Condition_concept_id Drug_concept_id;
run;

/*	Continue to prepare SUMMARY */
%do i=1 %to &num_part;

signon ts2k&i sascmd="&SAS_PROGRAM";

%syslput i=&i;
%syslput num_part=&num_part;
%syslput DATAWRK=&DATAWRK;
%syslput TOT_GRP=&TOT_GRP;
%syslput WRKFOLDER=&wrkfolder;
%syslput NUM_PASSES=&num_passes;
%syslput NUM_MATCHES=&num_matches;
%syslput DAYS_ENROLLED=&days_enrolled;
%syslput DEL_INTERM=&del_interm;

rsubmit ts2k&i wait=no log="&wrkfolder./ts2k&i..txt";
LIBNAME WRK "&WRKFOLDER";
options CPUCOUNT=ACTUAL THREADS;

	proc sql THREADS;
	create table &DATAWRK.._Cases_groups_drugs_&i as
	select T1.Condition_concept_id, T2.Drug_concept_id, T1.group, T1.Total_cases   
	from &DATAWRK.._Cases_counts_all_&i T1,
    	 &DATAWRK..drugs_of_interest T2 
	order by T1.condition_concept_id, T1.Group, T2.Drug_concept_id;
	quit; 

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_counts_all_&i _Cases_drugs_info_&i;
    quit;
	run;
	%end;

	proc sort data=&DATAWRK.._Cases_counts_by_drugs_&i THREADS;
	by Condition_concept_id Group Drug_concept_id;
	run;

	data &DATAWRK.._Cases_summary_&i;
	merge &DATAWRK.._Cases_counts_by_drugs_&i &DATAWRK.._Cases_groups_drugs_&i ;
	by Condition_concept_id Group Drug_concept_id;
	if Exposed_cases EQ . then Exposed_cases=0; 
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_counts_by_drugs_&i _Cases_groups_drugs_&i;
    quit;
	run;
	%end;

	proc sort data=&DATAWRK.._Cases_summary_&i THREADS;
	by Condition_concept_id Group;
	run;

	proc sort data= &DATAWRK.._Controls_counts_all_&i THREADS;
	by Condition_concept_id Group;
	run;

	data &DATAWRK.._Summary_&i;
	merge &DATAWRK.._Cases_summary_&i (IN=SET1) &DATAWRK.._Controls_counts_all_&i (IN=SET2);
	by Condition_concept_id Group;
	if SET1 AND SET2;
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Cases_summary_&i _Controls_counts_all_&i;
    quit;
	run;
	%end;

	proc sort data= &DATAWRK.._Controls_counts_by_drugs_&i THREADS;
	by Condition_concept_id Group Drug_concept_id;
	run;
	
	data  &DATAWRK.._Summary_&i;
	merge &DATAWRK.._Summary_&i (IN=SET1) &DATAWRK.._Controls_counts_by_drugs_&i;
	by Condition_concept_id Group Drug_concept_id;
	if Exposed_controls EQ . then Exposed_controls=0;
	if (Exposed_cases EQ 0) AND (Exposed_controls EQ 0) then delete; 
	if SET1;
	T=Exposed_cases*(Total_controls - Exposed_controls)/(Total_cases+Total_controls);
	B=Exposed_controls*(Total_cases - Exposed_cases)/(Total_cases+Total_controls);
	run;

	%if  &DEL_INTERM=1 %then
	%do;
    proc datasets lib=WRK NOLIST NOWARN;
	delete _Controls_counts_by_drugs_&i Out1 Out2;
    quit;
	run;
	%end;

endrsubmit;
%end;

waitfor _all_ %do i=1 %to &num_part; ts2k&i %end;;



%do i=1 %to &num_part;
signoff ts2k&i;
%end;

%end; /* ind_ind=0*/


%if &ind_ind=0 %then %do;
data &DATAWRK.._Summary_;
set %do i=1 %to &num_part; &DATAWRK.._Summary_&i  %end;
;
run;

%if  &del_interm=1 %then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete %do i=1 %to &num_part; _Summary_&i %end;
;
quit;
run;
%end;
%end; /*ind_ind=0*/

%if &s_window<0 %then 
%do; %let SW=%eval(-1*&s_window); %let dwindo=n&SW; %end; %else %let dwindo=&s_window;

%let filename=&cc._run&rnm._&dbn._s&dwindo.b&B_days.de&days_enrolled.d&p_window_drugs.c&p_window_cond.p&num_passes.m&num_matches._vis_&vis._nest_&ind_ind._drug_&drug_oc;
%let filename2=&cc._run&rnm._&dbn._s&dwindo.b&B_days.de&days_enrolled.d&p_window_drugs.c&p_window_cond.p&num_passes.m&num_matches._vis_&vis._nest_&ind_ind._drug_&drug_oc._c;

%let filename_sum=SUMMARY_&cc._run&rnm._&dbn._s&dwindo.b&B_days.de&days_enrolled.d&p_window_drugs.c&p_window_cond.p&num_passes.m&num_matches._vis_&vis._nest_&ind_ind._drug_&drug_oc;


data &DATAWRK.._Summary_Mo;
set &DATAWRK.._Summary_ (rename=(Exposed_cases= Eca Total_controls=Tco Exposed_controls=Eco Total_cases=Tca));
run; 

proc sql THREADS;
create table &DATAWRK..CC_method_out as
select T1.Drug_concept_id, T1.Condition_concept_id, sum(T1.T)/sum(T1.B) as score,
sum((Eca+(Tco-Eco))*(Eca*(Tco-Eco))/((Tca+Tco)*(Tca+Tco)))/(2*((sum(Eca*(Tco-Eco)/(Tca+Tco)))**2)) as sigma21,
sum(((Eco+(Tco-Eco))*((Tca-Eca)*Eco)+((Tca-Eca)+Eco)*(Eca*(Tco-Eco)))/((Tca+Tco)*(Tca+Tco)))/(2*sum(Eca*(Tco-Eco)/(Tca+Tco))*sum((Tca-Eca)*Eco/(Tca+Tco))) as sigma22,
sum(((Tca-Eca)+Eco)*((Tca-Eca)*Eco)/((Tca+Tco)*(Tca+Tco)))/(2*((sum((Tca-Eca)*Eco/(Tca+Tco)))**2)) as sigma23
from &DATAWRK.._Summary_Mo T1
group by T1.Drug_concept_id, T1.Condition_concept_id;

create table &DATAWRK..CC_method_data_sum as
select T1.Drug_concept_id, T1.Condition_concept_id, 
sum(T1.Exposed_cases) as Exposed_cases,
sum(T1.Exposed_controls) as Exposed_controls,
sum(T1.Total_cases) as Number_of_cases,
sum(T1.Total_controls) as Number_of_controls
from &DATAWRK.._Summary_ T1
group by T1.Drug_concept_id, T1.Condition_concept_id;

quit;

data &DATAWRK..CC_method_out (drop=sigma21 sigma22 sigma23);
set &DATAWRK..CC_method_out;
SE=sqrt(sigma21+sigma22+sigma23);
if score NE 0 then score=log(score);
 else do; score=0; SE=500000; end;
run;

data &DATAWRK..out1;
set &DATAWRK..CC_method_out;
where score NE .;
run;

data _null_;
   file "&TEXT_OUT_DIR./&filename..txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Drug_concept_id"
       ','
          "Condition_concept_id"
       ','
          "score"
		','
          "standard_error"
       ;
     end;
   set  &DATAWRK..out1   end=EFIEOD;
       format Drug_concept_id best12. ;
       format Condition_concept_id best12. ;
       format score best12. ;
	   format SE best12. ;
     do;
       EFIOUT + 1;
       put Drug_concept_id @;
       put Condition_concept_id @;
       put score @;
	   put SE ;
       ;
     end;
    run;

data _null_;
    file "&TEXT_OUT_DIR./&filename_sum..txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Drug_concept_id"
       ','
          "Condition_concept_id"
       ','
          "Exposed_cases"
		','
          "Exposed_controls"
		','
          "Number_of_cases"
		','
          "Number_of_controls"
       ;
     end;
   set  &DATAWRK..CC_method_data_sum   end=EFIEOD;
       format Drug_concept_id best12. ;
       format Condition_concept_id best12. ;
       format Exposed_cases best12. ;
	   format Exposed_controls best12. ;
	   format Number_of_cases best12. ;
	   format Number_of_controls best12. ;
     do;
       EFIOUT + 1;
       put Drug_concept_id @;
       put Condition_concept_id @;
       put Exposed_cases @;
	   put  Exposed_controls @;
	   put  Number_of_cases @;
	   put  Number_of_controls;
       ;
     end;
    run;

proc sql THREADS;
create table &DATAWRK.._summary_OR as
select T1.Drug_concept_id, T1.Condition_concept_id,
sum(T1.Exposed_cases)*(sum(T1.Total_controls) - sum(T1.Exposed_controls))/(sum(T1.Exposed_controls)*(sum(T1.Total_cases)-sum(T1.Exposed_cases))) as score,
sqrt(1/sum(T1.Exposed_cases) + 1/(sum(T1.Total_controls) - sum(T1.Exposed_controls)) + 1/sum(T1.Exposed_controls) + 1/(sum(T1.Total_cases)-sum(T1.Exposed_cases))) as SE
from &DATAWRK.._summary_ T1
group by T1.Drug_concept_id, T1.Condition_concept_id;
quit;

data &DATAWRK..out2;
set &DATAWRK.._summary_or;
where score NE .;
if score NE 0 then score=log(score);
 else do; score=0; SE=500000; end;
run;

	data _null_;
    %let _EFIERR_ = 0; 
    %let _EFIREC_ = 0; 
    file "&TEXT_OUT_DIR./&filename2..txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Drug_concept_id"

       ','
          "Condition_concept_id"
       ','
          "score"
		','
          "standard_error"
       ;
     end;
   set  &DATAWRK..out2   end=EFIEOD;
       format Drug_concept_id best12. ;
       format Condition_concept_id best12. ;
       format score best12. ;
	   format SE best12. ;
     do;
       EFIOUT + 1;
       put Drug_concept_id @;
       put Condition_concept_id @;
       put score @;
	   put SE ;
       ;
     end;
    if _ERROR_ then call symputx('_EFIERR_',1);  
    if EFIEOD then call symputx('_EFIREC_',EFIOUT);
    run;

%if &RLR=1 %then %do;

/* PHREG CLR PART */ 
%if &ind_ind=0 %then %do;

proc sort data=&DATAWRK.._summary_ out=&DATAWRK.._s_for_r (keep=Condition_concept_id Drug_concept_id group) NODUPKEY;
by Condition_concept_id Drug_concept_id group;
run;

data &DATAWRK.._cases_all (keep=Person_id Condition_concept_id group Y Index_date);
set %do i=1 %to &num_part; &DATAWRK.._cases_&i  %end;
;
Y=1;
run;

data &DATAWRK.._controls_all (keep=Person_id Condition_concept_id group Y Index_date);
set %do i=1 %to &num_part; &DATAWRK.._controls_fin_&i  %end;
;
Y=0;
run;

data &DATAWRK.._for_regr_all;
set &DATAWRK.._cases_all &DATAWRK.._controls_all;
run;

proc sort data=&DATAWRK.._for_regr_all;
by Condition_concept_id group;
run;

proc sort data=&DATAWRK.._s_for_r out=&DATAWRK.._s_for_r2 
(keep=Condition_concept_id group) NODUPKEY;
by Condition_concept_id group;
run;


data &DATAWRK.._for_regr_all;
merge &DATAWRK.._for_regr_all (IN=SET1) &DATAWRK.._s_for_r2 (IN=SET2);
by Condition_concept_id group;
if SET1 AND SET2;
run;

%if &CHA=1 %then %do;

proc sort data=&DATAWRK.._for_regr_all out=&DATAWRK.._for_regr_pindex (keep=Person_id Index_date) NODUPKEY;
by Person_id Index_date;
run;

proc sql THREADS;
%if &rrun=1 %then %do;
create table &DATAWRK..CHA_for_1 as
select DISTINCT T1.Person_id, T1.Index_date, T2.Diag_category_id, T2.Weight
from &DATAWRK.._for_regr_pindex T1, &DATAWRK..CHA_concepts T2, &DATAIN..&Condition_era_table T3
where T1.Person_id=T3.Person_id
AND T2.Target_concept_id=T3.Condition_concept_id
AND T3.Condition_era_start_date <= T1.Index_date
AND T1.Index_date <= T3.Condition_era_start_date + &CHW
/*AND T3.Condition_occurrence_type = &PWC*/
order by T1.Person_id, T1.Index_date, T2.Diag_category_id;

create table &DATAWRK..CHA_for_2 as
select T1.Person_id, T1.Index_date, sum(T1.Weight) as Charlson_index
from &DATAWRK..CHA_for_1 T1
group by  T1.Person_id, T1.Index_date; %end;

create table &DATAWRK..DR_for_2 as
select T1.Person_id, T1.Index_date, count( DISTINCT T2.Drug_concept_id) as drug_count
from &DATAWRK.._for_regr_pindex T1, &DATAIN..&Drug_era_table T2
where T1.Person_id=T2.Person_id
AND T2.Drug_era_start_date <= T1.Index_date
AND T1.Index_date <= T2.Drug_era_end_date + &cow
/*AND T2.Drug_Exposure_Type = &PWD*/
group by T1.Person_id, T1.Index_date;

create table &DATAWRK..CNDS_for_2 as
select T1.Person_id, T1.Index_date, count( DISTINCT T2.Condition_concept_id) as cond_count
from &DATAWRK.._for_regr_pindex T1, &DATAIN..&Condition_era_table T2
where T1.Person_id=T2.Person_id
AND T2.Condition_era_start_date <= T1.Index_date
AND T1.Index_date <= T2.Condition_era_start_date + &cow
/*AND T2.Condition_occurrence_type = &PWC*/
group by T1.Person_id, T1.Index_date;

create table &DATAWRK..VIS_for_2 as
select T1.Person_id, T1.Index_date, count( DISTINCT T2.visit_start_date) as visit_count
from &DATAWRK.._for_regr_pindex T1, &DATAWRK..Visit_occurrence1 T2
where T1.Person_id=T2.Person_id
AND T2.Visit_start_date <= T1.Index_date
AND T1.Index_date <= T2.Visit_start_date + &cow
group by T1.Person_id, T1.Index_date;
quit;

data &DATAWRK.._for_regr_pindex;
merge &DATAWRK.._for_regr_pindex  (IN=SET1) %if &rrun=1 %then %do; &DATAWRK..CHA_for_2 %end; &DATAWRK..DR_for_2 &DATAWRK..CNDS_for_2 
&DATAWRK..VIS_for_2;
by Person_id Index_date;
%if &rrun=1 %then %do; if Charlson_index = . then Charlson_index = 0; %end;
if drug_count =. then drug_count=0;
if cond_count =. then cond_count=0;
if visit_count =. then visit_count=0;
if SET1;
run; 

proc sort data=&DATAWRK.._for_regr_all;
by Person_id Index_date;
run;

data &DATAWRK.._for_regr_all;
merge &DATAWRK.._for_regr_all  (IN=SET1) &DATAWRK.._for_regr_pindex (IN=SET2);
by Person_id Index_date;
if SET1 AND SET2;
run; 

%end;


proc sort data=&DATAWRK.._for_regr_all;
by Condition_concept_id Person_id;
run;

data &DATAWRK.._cases_drugs_conditions_ (drop=Index_date);
set %do i=1 %to &num_part; &DATAWRK.._cases_drugs_conditions_&i  %end;;
run;

data &DATAWRK.._controls_drugs_conditions_ (drop=Index_date);
set %do i=1 %to &num_part; &DATAWRK.._controls_drugs_conditions_&i  %end;;
run;

data &DATAWRK.._cases_drugs_for_regr;
set &DATAWRK.._cases_drugs_conditions_ &DATAWRK.._controls_drugs_conditions_;
run;

proc sort data=&DATAWRK.._cases_drugs_for_regr;
by Condition_concept_id Drug_concept_id group;
run;

data &DATAWRK.._cases_drugs_for_regr;
merge &DATAWRK.._cases_drugs_for_regr (IN=SET1) &DATAWRK.._s_for_r (IN=SET2);
by Condition_concept_id Drug_concept_id group;
if SET1 AND SET2;
run;

proc sort data=&DATAWRK.._cases_drugs_for_regr;
by Condition_concept_id Person_id;
run;

proc sort data=&DATAWRK.._cases_drugs_for_regr out=&DATAWRK.._cases_drugs_uni (keep=Condition_concept_id Drug_concept_id) NODUPKEY;
by Condition_concept_id Drug_concept_id;
run;

data &DATAWRK.._null_;
set &DATAWRK.._cases_drugs_uni;
i+1;
ii=left(put(i, 10.));
call symput('CONDI'||ii,Condition_concept_id);
call symput('DRUGI'||ii,Drug_concept_id);
call symput('TOT_ALL',ii);
run;

%let bynum=&num_part;
options autosignon=yes;
%do j=1 %to &bynum;
signon ts3k&j sascmd="&SAS_PROGRAM";

%syslput j=&j;
%syslput num_part=&num_part;
%syslput DATAWRK=&DATAWRK;
%syslput TOT_GRP=&TOT_GRP;
%syslput WRKFOLDER=&wrkfolder;
%syslput NUM_PASSES=&num_passes;
%syslput NUM_MATCHES=&num_matches;
%syslput DAYS_ENROLLED=&days_enrolled;
%syslput DEL_INTERM=&del_interm;
%syslput TOT_ALL=&TOT_ALL;
%syslput BYNUM=&bynum;
%syslput CHA=&CHA;
%syslput BLR=&blr;
%syslput DATAIN=&datain;
%syslput CDMDATA=&cdmdata;
%syslput DRUG_ERA_TABLE=&DRUG_ERA_TABLE;
%syslput CONDITION_ERA_TABLE=&CONDITION_ERA_TABLE;
%syslput COW=&cow;
%syslput PWD=&pwd;
%syslput PWC=&pwc;
%syslput DIRE=&dire;
%syslput B=&B;
%syslput CLR=&clr;
%syslput RRUN=&rrun;
%syslput HYPER=&hyper;
%syslput CNDS_BLR=&cnds_blr;
%syslput DC_BLR=&dc_blr;
%syslput CC_BLR=&cc_blr;
%syslput VIS_BLR=&vis_blr;
%syslput CHA_BLR=&cha_blr;


rsubmit ts3k&j wait=no log="&wrkfolder./ts3k&j..txt";

LIBNAME CDM "&CDMDATA"; /* IZ: commenetd out */


LIBNAME WRK "&WRKFOLDER";
options CPUCOUNT=ACTUAL THREADS;


data &DATAWRK.._null_;
set &DATAWRK.._cases_drugs_uni;
i+1;
ii=left(put(i, 10.));
call symput('CONDI'||ii,Condition_concept_id);
call symput('DRUGI'||ii,Drug_concept_id);
run;

%nrstr(%%)let cvar=&J;

%do M=&J %to &TOT_ALL %by &BYNUM;
%nrstr(%%)put 'CVAR=' &cvar;
%nrstr(%%)let cid=&&CONDI&cvar;
%nrstr(%%)let did=&&DRUGI&cvar;

data &DATAWRK.._cases_drugs_&cvar (drop=Condition_concept_id);
set &DATAWRK.._cases_drugs_for_regr;
where Condition_concept_id=&cid AND Drug_concept_id=&did;
run;

data &DATAWRK.._for_regr_&cvar (drop=Condition_concept_id);
set &DATAWRK.._for_regr_all;
where Condition_concept_id=&cid;
run;

data &DATAWRK.._for_regr_&cvar;
merge &DATAWRK.._for_regr_&cvar (IN=SET1) &DATAWRK.._cases_drugs_&cvar (IN=SET2);
by Person_id;
if Drug_concept_id NE . then Drug_concept_id=1;
 else Drug_concept_id=0;
if Y=1 then Time=1;
   else Time=2;
if SET1;
run;

data &DATAWRK.._s_fr_r_&cvar (keep=Condition_concept_id group);
set &DATAWRK.._s_for_r;
where (Drug_concept_id=&did) AND (Condition_concept_id=&cid);
run;

proc sort data=&DATAWRK.._s_fr_r_&cvar out=&DATAWRK.._s_fr_r_&cvar NODUPKEY;
by group;
run;

proc sort data=&DATAWRK.._for_regr_&cvar;
by group;
run;

data &DATAWRK.._for_regr_&cvar;
merge &DATAWRK.._for_regr_&cvar (IN=SET1) &DATAWRK.._s_fr_r_&cvar (IN=SET2);
by group;
if SET1 AND SET2;
run;

%if &CLR=1 %then %do;
%if &CHA=0 %then %do;
proc phreg data=&DATAWRK.._for_regr_&cvar OUTEST=&DATAWRK.._for_out_&cvar COVOUT;
   model Time*Y(0)= Drug_concept_id / ties=discrete;
      strata group;
run;
%end;

%if &CHA=1 %then %do;
proc phreg data=&DATAWRK.._for_regr_&cvar OUTEST=&DATAWRK.._for_out_&cvar COVOUT;
   model Time*Y(0)= Drug_concept_id %if &RRUN=1 %then %do; Charlson_index %end; drug_count cond_count visit_count/ ties=discrete;
      strata group;
run;
%end;

data &DATAWRK.._for_out1_&cvar (rename=(Drug_concept_id=score)); 
set &DATAWRK.._for_out_&cvar (obs=1);
keep Drug_concept_id;
run;

data &DATAWRK.._for_out2_&cvar (keep=STDERR); 
set &DATAWRK.._for_out_&cvar (firstobs=2 obs=2);
STDERR=SQRT(Drug_concept_id);
run;

data &DATAWRK.._for_out_&cvar;
label Drug_concept_id='Drug_concept_id'
Condition_concept_id='Condition_concept_id'
STDERR='STDERR';
merge &DATAWRK.._for_out1_&cvar &DATAWRK.._for_out2_&cvar;
Drug_concept_id=&did;
Condition_concept_id=&cid;
run;
%end;
/* repeat end*/
%if  ((&DEL_INTERM=1) AND (&BLR=0)) %then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete
_for_out1_&cvar
_for_out2_&cvar
_s_fr_r_&cvar
_cases_drugs_&cvar
;
quit;
run;
%end;


/* BLR=1 */
%if &BLR=1 %then %do;

proc sql THREADS;

create table &DATAWRK..DRUGS_BLR_&cvar as
select DISTINCT T1.Person_id, T2.Drug_concept_id as var_n, 1 as value
from &DATAWRK.._for_regr_&cvar T1, &DATAIN..&Drug_era_table T2
where T1.Person_id=T2.Person_id
AND T2.Drug_era_start_date <= T1.Index_date
AND T1.Index_date <= T2.Drug_era_end_date + &cow
/*AND T2.Drug_Exposure_Type = &PWD*/
order by T1.Person_id;

create table &DATAWRK..CNDS_BLR_&cvar as
select DISTINCT T1.Person_id, T2.Condition_concept_id as var_n, 1 as value
from &DATAWRK.._for_regr_&cvar T1, &DATAIN..&Condition_era_table T2
where T1.Person_id=T2.Person_id
AND T2.Condition_era_start_date < T1.Index_date
AND T1.Index_date <= T2.Condition_era_start_date + &cow
/*AND T2.Condition_occurrence_type = &PWC*/
order by T1.Person_id;

create table &DATAWRK..DC_BLR_&cvar as
select DISTINCT T1.Person_id, T1.drug_count as value
from &DATAWRK.._for_regr_&cvar T1;

create table &DATAWRK..CC_BLR_&cvar as
select DISTINCT T1.Person_id, T1.cond_count as value
from &DATAWRK.._for_regr_&cvar T1;

create table &DATAWRK..VIS_BLR_&cvar as
select DISTINCT T1.Person_id, T1.visit_count as value
from &DATAWRK.._for_regr_&cvar T1;

%if &CHA_BLR=1 %then %do;
%if &RRUN=1 %then %do;
create table &DATAWRK..CHA_BLR_&cvar as
select DISTINCT T1.Person_id, T1.Charlson_index as value
from &DATAWRK.._for_regr_&cvar T1;
%end;
%end;

quit;

data &DATAWRK..for_blr_&cvar;
set &DATAWRK..DRUGS_BLR_&cvar 
%if &CNDS_BLR=1 %then %do; &DATAWRK..CNDS_BLR_&cvar %end;
;
where var_n NE &cid;
run; 

proc sql THREADS;
create table &DATAWRK..MAX_D_&cvar as
select max(var_n) as MAX_VAR
from &DATAWRK..for_blr_&cvar;
quit;

data _null_;
set &DATAWRK..MAX_D_&cvar;
call symput('max_v', put(MAX_VAR,20.));
run;

%nrstr(%%)let max_=&max_v;

data &DATAWRK..DC_BLR_&cvar;
set &DATAWRK..DC_BLR_&cvar;
var_n=%eval(&max_ +1);
run;

data &DATAWRK..CC_BLR_&cvar;
set &DATAWRK..CC_BLR_&cvar;
var_n=%eval(&max_ + 2);
run;


data &DATAWRK..VIS_BLR_&cvar;
set &DATAWRK..VIS_BLR_&cvar;
var_n=%eval(&max_ + 3);
run;

%if &CHA_BLR=1 %then %do;
data &DATAWRK..CHA_BLR_&cvar;
set &DATAWRK..CHA_BLR_&cvar;
var_n=%eval(&max_ + 4);
run;
%end;

data &DATAWRK..for_blr_&cvar;
set &DATAWRK..for_blr_&cvar
%if &DC_BLR=1 %then %do; &DATAWRK..DC_BLR_&cvar (where=(value NE 0)) %end;
%if &CC_BLR=1 %then %do; &DATAWRK..CC_BLR_&cvar (where=(value NE 0)) %end;
%if &VIS_BLR=1 %then %do; &DATAWRK..VIS_BLR_&cvar (where=(value NE 0)) %end;
%if &CHA_BLR=1 %then %do; 
%if &RRUN=1 %then %do; 
&DATAWRK..CHA_BLR_&cvar 
%end;
%end;
;

run;

data &DATAWRK.._for_regr_y_&cvar (keep=Person_id y); 
set &DATAWRK.._for_regr_&cvar;
if y=0 then y=-1;
run;

proc sort data=&DATAWRK..for_blr_&cvar;
by Person_id;
run;

proc sort data=&DATAWRK.._for_regr_y_&cvar;
by Person_id;
run;

data &DATAWRK..for_blr_&cvar;
merge &DATAWRK..for_blr_&cvar &DATAWRK.._for_regr_y_&cvar;
by Person_id;
run; 

proc sort data=&DATAWRK..for_blr_&cvar out=&DATAWRK..reports_u_&cvar (keep=Person_id) NODUPKEY;
by Person_id;
run;

data &DATAWRK..reports_u_&cvar;
set &DATAWRK..reports_u_&cvar;
report_d=_n_;
run;

proc sort data=&DATAWRK..for_blr_&cvar;
by Person_id;
run;

data &DATAWRK..for_blr_&cvar (drop=Person_id);
merge &DATAWRK..for_blr_&cvar &DATAWRK..reports_u_&cvar;
by Person_id;
run;

proc sql THREADS;
create table &DATAWRK..var_freq_&cvar as
select T1.var_n, count(T1.var_n) as var_n_freq
from &DATAWRK..for_blr_&cvar T1
group by T1.var_n;
quit;

proc sort data=&DATAWRK..var_freq_&cvar;
by DESCENDING var_n_freq;
run;

data &DATAWRK..var_n_new_&cvar;
set &DATAWRK..var_freq_&cvar;
var_n_new=_n_;
run;

proc sql THREADS;
create table &DATAWRK..report_data_new_&cvar as
select T1.y, T1.report_d, T2.var_n_new as var_n, T1.value
from &DATAWRK..for_blr_&cvar T1, &DATAWRK..var_n_new_&cvar T2
where T1.var_n=T2.var_n
order by T1.report_d, T2.var_n_new;
quit;

proc iml;

USE &DATAWRK..report_data_new_&cvar; 
READ all var{report_d var_n y value};
CLOSE &DATAWRK..report_data_new_&cvar;

N=nrow(y);

c_EVENT=1;

filename out "&DIRE./bbr_in_&cvar..txt"; 
file out lrecl=1000000; 
      do i=1 to N;
if y[i]=c_EVENT then put('1') $1. @; 
else put('-1') $2. @;
here1:
x=var_n[i]; x=char(x); x=compbl(x);
vx=length(x);
put(x) $varying12. vx @;
put(':') @;
x=value[i]; x=char(x); x=compbl(x);
vx=length(x);
put(x) $varying12. vx @;


if i<N then if report_d[i]=report_d[i+1] then
do; i=i+1; GOTO here1; end;

put;
      end;
          
   closefile out;

quit;


data _null_;
x "C:\BBR\BBRtrain.exe -p 2 -V &HYPER &DIRE./bbr_in_&cvar..txt &DIRE./file_out_&cvar..txt";
run;
quit;


DATA 	&DATAWRK..Features_&cvar (keep=feature)
		&DATAWRK..Beta&cvar (keep=beta);
 retain indicator 0;
   LENGTH WORDTEXT $ 20;
   INFILE "&DIRE./file_out_&cvar..txt" FLOWOVER lrecl=100000;
   INPUT WORDTEXT @@;
if (indicator EQ 1) AND (WORDTEXT NE 'beta') then do; feature=input(WORDTEXT,best12.0); output &DATAWRK..Features_&cvar; end;
if (indicator EQ 2) AND (WORDTEXT NE 'threshold') then do; beta=input(WORDTEXT,20.0); output &DATAWRK..Beta&cvar; end;
if WORDTEXT EQ 'topicFeats' then indicator=1;
if WORDTEXT EQ 'beta' 		then indicator=2;
if WORDTEXT EQ 'threshold' 	then indicator=3;
RUN;

data &DATAWRK..Beta&cvar (rename=(beta=score));
set &DATAWRK..Beta&cvar end=last;
if last then delete;
run;



	data &DATAWRK..Beta&cvar (where=(Drug_concept_id=&did));
	merge &DATAWRK..var_n_new_&cvar (rename=(var_n=Drug_concept_id)) &DATAWRK..Beta&cvar;
	keep Drug_concept_id score Condition_concept_id;
	Condition_concept_id=&cid;
    run; 

proc sort data=&DATAWRK..report_data_new_&cvar out=&DATAWRK..reports_uni_&cvar (keep=report_d) NODUPKEY;
by report_d;
run;

proc sql THREADS;
create table &DATAWRK..MAX_REP_&cvar as
select max(report_d) as MAX_VAR
from &DATAWRK..reports_uni_&cvar;
quit;

data _null_;
set &DATAWRK..MAX_REP_&cvar;
call symput('max_rep', put(MAX_VAR,20.));
run;

%nrstr(%%)let max_r=&max_rep;

proc surveyselect data=&DATAWRK..reports_uni_&cvar  method = urs sampsize = %eval(&max_r+0)
   rep=&B seed=12345 out=&DATAWRK..reports_s_&cvar;
   id report_d;
run;
/* for sd */

%nrstr(%%)let rep=0;

data &DATAWRK..Beta_alls_&cvar;
set _null_;
run;

%do rn=1 %to &B;

%nrstr(%%)let rep=%eval(&rep+1);


data &DATAWRK..reports_s2_&cvar (keep=report_d report_dn);
retain report_dn 0;
set &DATAWRK..reports_s_&cvar;
do i=1 to NumberHits;
report_dn=report_dn+1;
output;
end;
where replicate=&rep; /* NB */
run; 

proc sql THREADS;
create table &DATAWRK..report_data_M_&cvar as
select T1.y, T1.var_n, T1.value, T2.report_dn as report_d
from &DATAWRK..report_data_new_&cvar T1, &DATAWRK..reports_s2_&cvar T2 
where T1.report_d = T2.report_d
order by T2.report_dn, T1.var_n; 

create table &DATAWRK..var_n_uni_&cvar as
select DISTINCT T1.var_n
from &DATAWRK..report_data_M_&cvar T1
order by T1.var_n;
quit;


proc iml;

USE &DATAWRK..report_data_M_&cvar; 
READ all var{report_d var_n y value};
CLOSE &DATAWRK..report_data_M_&cvar;

N=nrow(y);

c_EVENT=1;

filename out "&DIRE./bbr_in_&cvar..txt"; 
file out lrecl=1000000; 
      do i=1 to N;
if y[i]=c_EVENT then put('1') $1. @; 
else put('-1') $2. @;
here1:
x=var_n[i]; x=char(x); x=compbl(x);
vx=length(x);
put(x) $varying12. vx @;
put(':') @;
x=value[i]; x=char(x); x=compbl(x);
vx=length(x);
put(x) $varying12. vx @;


if i<N then if report_d[i]=report_d[i+1] then
do; i=i+1; GOTO here1; end;

put;
      end;
          
   closefile out;

quit;


data _null_;
x "C:\BBR\BBRtrain.exe -p 2 -V &HYPER &DIRE./bbr_in_&cvar..txt &DIRE./file_out_&cvar..txt";
run;
quit;


DATA 	&DATAWRK..Features_&cvar (keep=feature)
		&DATAWRK..Beta_&cvar._&rep (keep=beta);
 retain indicator 0;
   LENGTH WORDTEXT $ 20;
   INFILE "&DIRE./file_out_&cvar..txt" FLOWOVER lrecl=100000;
   INPUT WORDTEXT @@;
if (indicator EQ 1) AND (WORDTEXT NE 'beta') then do; feature=input(WORDTEXT,best12.0); output &DATAWRK..Features_&cvar; end;
if (indicator EQ 2) AND (WORDTEXT NE 'threshold') then do; beta=input(WORDTEXT,20.0); output &DATAWRK..Beta_&cvar._&rep; end;
if WORDTEXT EQ 'topicFeats' then indicator=1;
if WORDTEXT EQ 'beta' 		then indicator=2;
if WORDTEXT EQ 'threshold' 	then indicator=3;
RUN;

data &DATAWRK..Beta_&cvar._&rep (rename=(beta=score));
set &DATAWRK..Beta_&cvar._&rep end=last;
if last then delete;
run;

data &DATAWRK..Beta_&cvar._&rep;
merge &DATAWRK..var_n_uni_&cvar &DATAWRK..Beta_&cvar._&rep;
keep var_n score;
run; 

data &DATAWRK..Beta_alls_&cvar;
set &DATAWRK..Beta_alls_&cvar
&DATAWRK..Beta_&cvar._&rep;
run;

%if  (&DEL_INTERM=1)%then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete
Beta_&cvar._&rep
;
quit;
run;

data _null_;
  fileRef="ext2del";
  rc=filename(fileRef,"&DIRE./bbr_in_&cvar..txt");
  if rc=0 and fexist(fileRef) then rc=fdelete(fileRef);
  rc=filename(fileRef);
run; 

data _null_;
  fileRef="ext2del";
  rc=filename(fileRef,"&DIRE./file_out_&cvar..txt");
  if rc=0 and fexist(fileRef) then rc=fdelete(fileRef);
  rc=filename(fileRef);
run; 


data _null_;
  fileRef="ext2del";
  rc=filename(fileRef,"&DIRE./current_&cvar..txt");
  if rc=0 and fexist(fileRef) then rc=fdelete(fileRef);
  rc=filename(fileRef);
run; 

%end;


%end;

proc sql THREADS;
create table &DATAWRK..Beta_std_&cvar as
select T1.var_n, STD(T1.score) as sd
from &DATAWRK..Beta_alls_&cvar T1
group by T1.var_n;

create table &DATAWRK..Beta_std_fin_&cvar as
select T2.var_n as Drug_concept_id, T1.sd
from &DATAWRK..Beta_std_&cvar T1, &DATAWRK..Var_n_new_&cvar T2
where T1.var_n=T2.var_n_new
order by T2.var_n;
quit;

data &DATAWRK..Beta_std_fin_&cvar;
set &DATAWRK..Beta_std_fin_&cvar;
where Drug_concept_id=&did;
run;

data &DATAWRK..Beta&cvar;
merge &DATAWRK..Beta&cvar &DATAWRK..Beta_std_fin_&cvar;
by Drug_concept_id;
run;



%if  (&DEL_INTERM=1)%then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete
Beta_&cvar
Var_n_new_&cvar
Vis_blr_&cvar
_cases_drugs_&cvar
_for_regr_y_&cvar
_s_fr_r_&cvar
Beta_alls_&cvar
Beta_std_&cvar
Beta_std_fin_&cvar
Cc_blr_&cvar
Cnds_blr_&cvar
Dc_blr_&cvar
Drugs_blr_&cvar
Features_&cvar
Inter_blr_&cvar
Max_d_&cvar
Max_rep_&cvar
Reports_s2_&cvar
Reports_s_&cvar
Reports_uni_&cvar
Reports_u_&cvar
Report_data_m_&cvar
Report_data_new_&cvar
Var_freq_&cvar
_for_out1_&cvar
_for_out2_&cvar
Cha_blr_&cvar
For_blr_&cvar
;
quit;
run;
%end;

%end;
/* end of BLR */
%nrstr(%%)let cvar=%eval(&cvar+&BYNUM);

%end;


endrsubmit;
%end;

waitfor _all_ %do k=1 %to &bynum; ts3k&k %end;;
signoff _all_;

%if &clr=1 %then %do;

data &DATAWRK.._CLR_ALL;
set _null_;
run;

%do i=1 %to &TOT_ALL;
data &DATAWRK.._CLR_ALL;
set  &DATAWRK.._CLR_ALL &DATAWRK.._for_out_&i;
run;
 %end;

%end;




%if &blr=1 %then %do;

data &DATAWRK.._BLR_ALL;
set _null_;
run;

%do i=1 %to &TOT_ALL; 
data &DATAWRK.._BLR_ALL;
set &DATAWRK.._BLR_ALL  &DATAWRK..Beta&i;
run;
%end;

%end;

%if  &del_interm=1 %then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete 
%do m=1 %to &TOT_ALL; Beta&m _for_out_&m Var_n_uni_&m _for_regr_&m %end;
%do k=1 %to &bynum; Condition_era_&k
%if &RLR=0 %then %do;
_cases_drugs_conditions_&k
_controls_drugs_conditions_&k
_controls_fin_&k
_cases_&k
%end;
%end;
_s_for_r _s_for_r2
Cha_for_1 Cha_for_2 Cnds_for_2
Dr_for_2 Vis_for_2
_cases_drugs_for_regr
_cases_drugs_uni
_for_regr_all
_for_regr_pindex
;
quit;
run;
%end;


%if &s_window<0 %then 
%do; %let SW=%eval(-1*&s_window); %let dwindo=n&SW; %end; %else %let dwindo=&s_window;

%if &clr=1 %then %do;
%let filename3=&cc._run&rnm._&dbn._s&dwindo.b&B_days.de&days_enrolled.d&p_window_drugs.c&p_window_cond.p&num_passes.m&num_matches._vis_&vis._nest_&ind_ind._clr_cha_&cha._chw_&CHW._cow_&cow._drug_&drug_oc;

data _null_;
    %let _EFIERR_ = 0; 
    %let _EFIREC_ = 0; 
    file "&TEXT_OUT_DIR./&filename3..txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Drug_concept_id"
       ','
          "Condition_concept_id"
       ','
          "score"
	   ','
          "standard_error"
       ;
     end;
   set  &DATAWRK.._CLR_ALL   end=EFIEOD;
       format Drug_concept_id best12. ;
       format Condition_concept_id best12. ;
       format score best12. ;
	   format STDERR best12. ;
     do;
       EFIOUT + 1;
       put Drug_concept_id @;
       put Condition_concept_id @;
       put score @;
	   put STDERR;
       ;
     end;
    if _ERROR_ then call symputx('_EFIERR_',1);  
    if EFIEOD then call symputx('_EFIREC_',EFIOUT);
    run;
%end;


%if &blr=1 %then %do;

%let filename4=&cc._run&rnm._&dbn._s&dwindo.b&B_days.de&days_enrolled.d&p_window_drugs.c&p_window_cond.p&num_passes.m&num_matches._vis_&vis._nest_&ind_ind._blr_drug_&drug_oc;

data &DATAWRK..blr_params;
hyper_blr=&hyper;
cnds_blr=&cnds_blr;
vis_blr=&vis_blr;
dc_blr=&dc_blr;
cc_blr=&cc_blr;
cha_blr=&cha_blr;
cow=&cow;
chw=&CHW;
run;

data _null_;
    %let _EFIERR_ = 0; 
    %let _EFIREC_ = 0; 
    file "&TEXT_OUT_DIR./&filename4._param.txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Hyper"
       ','
          "cnds_blr"
       ','
          "vis_blr"
	   ','
          "dc_blr"
	   ','
          "cc_blr"
	   ','
          "cha_blr"
	   ','
          "cov_window"
	   ','
          "cha_window"
       ;
     end;
   set  &DATAWRK..blr_params   end=EFIEOD;
       format hyper_blr best12. ;
       format cnds_blr best12. ;
       format vis_blr best12. ;
	   format dc_blr best12. ;
	   format cc_blr best12. ;
       format cha_blr best12. ;
       format cow best12. ;
	   format chw best12. ;
     do;
       EFIOUT + 1;
       put hyper_blr @;
       put cnds_blr @;
       put vis_blr @;
	   put dc_blr @;
	   put cc_blr @;
       put cha_blr @;
       put cow @;
	   put chw;
       ;
     end;
    if _ERROR_ then call symputx('_EFIERR_',1);  
    if EFIEOD then call symputx('_EFIREC_',EFIOUT);
 run;



data _null_;
    %let _EFIERR_ = 0; 
    %let _EFIREC_ = 0; 
    file "&TEXT_OUT_DIR./&filename4..txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Drug_concept_id"
       ','
          "Condition_concept_id"
       ','
          "score"
	   ','
          "standard_error"
       ;
     end;
   set  &DATAWRK.._BLR_ALL   end=EFIEOD;
       format Drug_concept_id best12. ;
       format Condition_concept_id best12. ;
       format score best12. ;
	   format sd best12. ;
     do;
       EFIOUT + 1;
       put Drug_concept_id @;
       put Condition_concept_id @;
       put score @;
	   put sd;
       ;
     end;
    if _ERROR_ then call symputx('_EFIERR_',1);  
    if EFIEOD then call symputx('_EFIREC_',EFIOUT);
    run;
%end;

%end; /* ind_ind=0 */

/*** CLR ind_ind=1 ***/

%if &ind_ind=1 %then %do;

data &DATAWRK..Drugs_of_interest;
set &DATAWRK..Drugs_loop;
d_num=_n_;
run;

proc sort data=&DATAWRK.._summary_ out=&DATAWRK..all_uni_drugs (keep=Drug_concept_id) NODUPKEY;
by Drug_concept_id ;
run;

proc sort data=&DATAWRK.._summary_ out=&DATAWRK..all_conds_drugs (keep=Condition_concept_id group Drug_concept_id) NODUPKEY;
by  Drug_concept_id Condition_concept_id group;
run;

data &DATAWRK..all_uni_drugs;
merge &DATAWRK..all_uni_drugs (IN=SET1) &DATAWRK..Drugs_of_interest (IN=SET2);
by Drug_concept_id ;
if SET1 AND SET2;
run;
 
data &DATAWRK.._null_;
set &DATAWRK..all_uni_drugs;
i+1;
ii=left(put(i, 10.));
call symput('d_n'||ii,d_num);
call symput('DRUGI'||ii,Drug_concept_id);
call symput('TOT_ALL',ii);
run;

%put TOT_ALL= &TOT_ALL;

%let bynum=&num_part;
options autosignon=yes;
%do j=1 %to &bynum;
signon ts4k&j sascmd="&SAS_PROGRAM";

%syslput j=&j;
%syslput num_part=&num_part;
%syslput DATAWRK=&DATAWRK;
%syslput DATAIN=&DATAIN;
%syslput WRKFOLDER=&wrkfolder;
%syslput CDMDATA=&cdmdata;
%syslput NUM_PASSES=&num_passes;
%syslput NUM_MATCHES=&num_matches;
%syslput DAYS_ENROLLED=&days_enrolled;
%syslput DEL_INTERM=&del_interm;
%syslput TOT_ALL=&TOT_ALL;
%syslput BYNUM=&bynum;
%syslput CHA=&CHA;
%syslput CHW=&CHW;
%syslput PWD=&PWD;
%syslput PWC=&PWC;
%syslput COW=&COW;
%syslput Drug_era_table=&Drug_era_table;
%syslput Condition_era_table=&Condition_era_table;


rsubmit ts4k&j wait=no log="&wrkfolder./ts4k&j..txt";
LIBNAME &DATAIN "&CDMDATA";
LIBNAME &DATAWRK "&WRKFOLDER";
options CPUCOUNT=ACTUAL THREADS;


data &DATAWRK.._null_;
set &DATAWRK..all_uni_drugs;
i+1;
ii=left(put(i, 10.));
call symput('d_n'||ii,d_num);
call symput('DRUGI'||ii,Drug_concept_id);
run;

%nrstr(%%)let cvar=&J;

%do M=&J %to &TOT_ALL %by &BYNUM;

%nrstr(%%)let did=&&DRUGI&cvar;
%nrstr(%%)let MN=&&d_n&cvar;

data &DATAWRK.._cases_all_&MN (keep=Person_id Condition_concept_id group Y Index_date);
set &DATAWRK..Condition_era_&MN;
;
Y=1;
run;

data &DATAWRK.._controls_all_&MN (keep=Person_id Condition_concept_id group Y Index_date);
set &DATAWRK.._controls_fin_&MN;
;
Y=0;
run;

data &DATAWRK.._for_regr_all_&MN;
set &DATAWRK.._cases_all_&MN &DATAWRK.._controls_all_&MN;
run;

proc sort data=&DATAWRK.._for_regr_all_&MN;
by Condition_concept_id group;
run;

data &DATAWRK..all_conds_drugs_&MN (keep=Condition_concept_id group); 
set &DATAWRK..all_conds_drugs;
where Drug_concept_id=&did;
run;

data &DATAWRK.._for_regr_all_&MN;
merge &DATAWRK.._for_regr_all_&MN (IN=SET1) &DATAWRK..all_conds_drugs_&MN (IN=SET2);
by Condition_concept_id group;
if SET1 AND SET2;
run;
 
data &DATAWRK.._cases_drugs_conditions_&MN;
set &DATAWRK.._cases_drugs_conditions_&MN  &DATAWRK.._controls_drugs_conditions_&MN;
drop Index_date;
run; 

proc sort data=&DATAWRK.._cases_drugs_conditions_&MN;
by Condition_concept_id Person_id;
run;

%if &CHA=1 %then %do;

proc sort data=&DATAWRK.._for_regr_all_&MN out=&DATAWRK.._for_regr_pindex_&MN (keep=Person_id Index_date) NODUPKEY;
by Person_id Index_date;
run;

proc sql THREADS;
create table &DATAWRK..CHA_for_1_&MN as
select DISTINCT T1.Person_id, T1.Index_date, T2.Diag_category_id, T2.Weight
from &DATAWRK.._for_regr_pindex_&MN T1, &DATAWRK..CHA_concepts T2, &DATAIN..&Condition_era_table T3
where T1.Person_id=T3.Person_id
AND T2.Target_concept_id=T3.Condition_concept_id
AND T3.Condition_era_start_date <= T1.Index_date
AND T1.Index_date <= T3.Condition_era_start_date + &CHW
order by T1.Person_id, T1.Index_date, T2.Diag_category_id;

create table &DATAWRK..CHA_for_2_&MN as
select T1.Person_id, T1.Index_date, sum(T1.Weight) as Charlson_index
from &DATAWRK..CHA_for_1_&MN T1
group by  T1.Person_id, T1.Index_date;

create table &DATAWRK..DR_for_2_&MN as
select T1.Person_id, T1.Index_date, count( DISTINCT T2.Drug_concept_id) as drug_count
from &DATAWRK.._for_regr_pindex_&MN T1, &DATAIN..&Drug_era_table T2
where T1.Person_id=T2.Person_id
AND T2.Drug_era_start_date <= T1.Index_date
AND T1.Index_date <= T2.Drug_era_end_date + &cow
/*AND T2.Drug_Exposure_Type = &PWD*/
group by T1.Person_id, T1.Index_date;

create table &DATAWRK..CNDS_for_2_&MN as
select T1.Person_id, T1.Index_date, count( DISTINCT T2.Condition_concept_id) as cond_count
from &DATAWRK.._for_regr_pindex_&MN T1, &DATAIN..&Condition_era_table T2
where T1.Person_id=T2.Person_id
AND T2.Condition_era_start_date <= T1.Index_date
AND T1.Index_date <= T2.Condition_era_start_date + &cow
/*AND T2.Condition_occurrence_type = &PWC*/
group by T1.Person_id, T1.Index_date;

create table &DATAWRK..VIS_for_2_&MN as
select T1.Person_id, T1.Index_date, count( DISTINCT T2.visit_start_date) as visit_count
from &DATAWRK.._for_regr_pindex_&MN T1, &DATAWRK..Visit_occurrence1 T2
where T1.Person_id=T2.Person_id
AND T2.Visit_start_date <= T1.Index_date
AND T1.Index_date <= T2.Visit_start_date + &cow
group by T1.Person_id, T1.Index_date;
quit;

data &DATAWRK.._for_regr_pindex_&MN;
merge &DATAWRK.._for_regr_pindex_&MN  (IN=SET1) &DATAWRK..CHA_for_2_&MN &DATAWRK..DR_for_2_&MN &DATAWRK..CNDS_for_2_&MN &DATAWRK..VIS_for_2_&MN;
by Person_id Index_date;
if Charlson_index = . then Charlson_index = 0;
if drug_count =. then drug_count=0;
if cond_count =. then cond_count=0;
if visit_count =. then visit_count=0;
if SET1;
run; 

proc sort data=&DATAWRK.._for_regr_all_&MN;
by Person_id Index_date;
run;

data &DATAWRK.._for_regr_all_&MN;
merge &DATAWRK.._for_regr_all_&MN  (IN=SET1) &DATAWRK.._for_regr_pindex_&MN (IN=SET2);
by Person_id Index_date;
if SET1 AND SET2;
run; 
%end;

proc sort data=&DATAWRK.._for_regr_all_&MN;
by Condition_concept_id Person_id;
run;

data &DATAWRK.._for_regr_&MN;
merge &DATAWRK.._for_regr_all_&MN (IN=SET1) &DATAWRK.._cases_drugs_conditions_&MN (IN=SET2);
by Condition_concept_id Person_id;
if Drug_concept_id NE . then Drug_concept_id=1;
 else Drug_concept_id=0;
if Y=1 then Time=1;
   else Time=2;
if SET1;
run;

%if  ((&DEL_INTERM=1) AND (&BLR=0)) %then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete
All_conds_drugs_&cvar
Cha_for_1_&cvar
Cha_for_2_&cvar
Cnds_for_2_&cvar
Condition_era_&cvar
Dr_for_2_&cvar
_cases_all_&cvar
Vis_for_2_&cvar
_cases_drugs_conditions_&cvar
_controls_all_&cvar
_controls_drugs_conditions_&cvar
_for_out_&cvar
_for_regr_all_&cvar
_for_regr_pindex_&cvar
_controls_fin_&cvar
;
quit;
run;
%end;


%nrstr(%%)let cvar=%eval(&cvar+&BYNUM);

%end;


endrsubmit;
%end;

waitfor _all_ %do k=1 %to &bynum; ts4k&k %end;;
signoff _all_;

/* do regressions */
proc sort data=&DATAWRK..all_conds_drugs out=&DATAWRK..all_dc (keep=Condition_concept_id Drug_concept_id) NODUPKEY;
by Drug_concept_id Condition_concept_id;
run;

data &DATAWRK..all_dc;
merge &DATAWRK..all_dc (IN=SET1) &DATAWRK..all_uni_drugs (IN=SET2);
by Drug_concept_id;
if SET1 AND SET2;
run;

data &DATAWRK.._null_;
set &DATAWRK..all_dc;
i+1;
ii=left(put(i, 10.));
call symput('CONDI'||ii,Condition_concept_id);
call symput('DRUGI'||ii,Drug_concept_id);
call symput('D_N'||ii,d_num);
call symput('TOT_ALL',ii);
run;

%let bynum=&num_part;
options autosignon=yes;
%do j=1 %to &bynum;
signon ts5k&j sascmd="&SAS_PROGRAM";

%syslput j=&j;
%syslput num_part=&num_part;
%syslput DATAWRK=&DATAWRK;
%syslput WRKFOLDER=&wrkfolder;
%syslput NUM_PASSES=&num_passes;
%syslput NUM_MATCHES=&num_matches;
%syslput DAYS_ENROLLED=&days_enrolled;
%syslput DEL_INTERM=&del_interm;
%syslput TOT_ALL=&TOT_ALL;
%syslput BYNUM=&bynum;
%syslput CHA=&CHA;
%syslput BLR=&blr;
%syslput DATAIN=&datain;
%syslput CDMDATA=&cdmdata;
%syslput DRUG_ERA_TABLE=&DRUG_ERA_TABLE;
%syslput CONDITION_ERA_TABLE=&CONDITION_ERA_TABLE;
%syslput COW=&cow;
%syslput PWD=&pwd;
%syslput PWC=&pwc;
%syslput DIRE=&dire;
%syslput B=&B;
%syslput CLR=&clr;
%syslput HYPER=&hyper;
%syslput CNDS_BLR=&cnds_blr;
%syslput DC_BLR=&dc_blr;
%syslput CC_BLR=&cc_blr;
%syslput VIS_BLR=&vis_blr;
%syslput CHA_BLR=&cha_blr;

rsubmit ts5k&j wait=no log="&wrkfolder./ts5k&j..txt";
LIBNAME WRK "&WRKFOLDER";

LIBNAME CDM "&CDMDATA";



options CPUCOUNT=ACTUAL THREADS;


data &DATAWRK.._null_;
set &DATAWRK..all_dc;
i+1;
ii=left(put(i, 10.));
call symput('CONDI'||ii,Condition_concept_id);
call symput('DRUGI'||ii,Drug_concept_id);
call symput('D_N'||ii,d_num);
run;

%nrstr(%%)let cvar=&J;

%do M=&J %to &TOT_ALL %by &BYNUM;

%nrstr(%%)put 'CVAR=' &cvar;

%nrstr(%%)let cid=&&CONDI&cvar;
%nrstr(%%)let did=&&DRUGI&cvar;
%nrstr(%%)let MN=&&D_N&cvar;


data &DATAWRK.._for_regr2_&cvar;
set &DATAWRK.._for_regr_&MN;
where Condition_concept_id EQ &cid;
run;

%if &CLR=1 %then %do;
%if &CHA=0 %then %do;
proc phreg data=&DATAWRK.._for_regr2_&cvar OUTEST=&DATAWRK.._for_out_&cvar COVOUT;
   model Time*Y(0)= Drug_concept_id / ties=discrete;
      strata group;
run;
%end;

%if &CHA=1 %then %do;
proc phreg data=&DATAWRK.._for_regr2_&cvar OUTEST=&DATAWRK.._for_out_&cvar COVOUT;
   model Time*Y(0)= Drug_concept_id Charlson_index drug_count cond_count visit_count/ ties=discrete;
      strata group;
run;
%end;

data &DATAWRK.._for_out1_&cvar (rename=(Drug_concept_id=score)); 
set &DATAWRK.._for_out_&cvar (obs=1);
keep Drug_concept_id;
run;

data &DATAWRK.._for_out2_&cvar (keep=STDERR); 
set &DATAWRK.._for_out_&cvar (firstobs=2 obs=2);
STDERR=SQRT(Drug_concept_id);
run;

data &DATAWRK.._for_out_&cvar;
label Drug_concept_id='Drug_concept_id'
Condition_concept_id='Condition_concept_id'
STDERR='STDERR';
merge &DATAWRK.._for_out1_&cvar &DATAWRK.._for_out2_&cvar;
Drug_concept_id=&did;
Condition_concept_id=&cid;
run;
/* repeat end*/

%if  ((&DEL_INTERM=1) AND (&BLR=0)) %then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete
_for_out1_&cvar
_for_out2_&cvar
_s_fr_r_&cvar
_cases_drugs_&cvar
;
quit;
run;
%end;

%end;
/*** BLR ****/
%if &BLR=1 %then %do;
proc sql THREADS;
create table &DATAWRK..DRUGS_BLR_&cvar as
select DISTINCT T1.Person_id, T2.Drug_concept_id as var_n, 1 as value
from &DATAWRK.._for_regr2_&cvar T1, &DATAIN..&Drug_era_table T2
where T1.Person_id=T2.Person_id
AND T2.Drug_era_start_date <= T1.Index_date
AND T1.Index_date <= T2.Drug_era_end_date + &cow
/*AND T2.Drug_Exposure_Type = &PWD*/
order by T1.Person_id;

create table &DATAWRK..CNDS_BLR_&cvar as
select DISTINCT T1.Person_id, T2.Condition_concept_id as var_n, 1 as value
from &DATAWRK.._for_regr2_&cvar T1, &DATAIN..&Condition_era_table T2
where T1.Person_id=T2.Person_id
AND T2.Condition_era_start_date < T1.Index_date
AND T1.Index_date <= T2.Condition_era_start_date + &cow
/*AND T2.Condition_occurrence_type = &PWC*/
order by T1.Person_id;

create table &DATAWRK..VIS_BLR_&cvar as
select DISTINCT T1.Person_id, T1.visit_count as value
from &DATAWRK.._for_regr2_&cvar T1;

create table &DATAWRK..DC_BLR_&cvar as
select DISTINCT T1.Person_id, T1.drug_count as value
from &DATAWRK.._for_regr2_&cvar T1;

create table &DATAWRK..CC_BLR_&cvar as
select DISTINCT T1.Person_id, T1.cond_count as value
from &DATAWRK.._for_regr2_&cvar T1;

%if &CHA_BLR=1 %then %do;
create table &DATAWRK..CHA_BLR_&cvar as
select DISTINCT T1.Person_id, T1.Charlson_index as value
from &DATAWRK.._for_regr2_&cvar T1;
%end;

quit;

data &DATAWRK..for_blr_&cvar;
set &DATAWRK..DRUGS_BLR_&cvar 
%if &CNDS_BLR=1 %then %do; &DATAWRK..CNDS_BLR_&cvar %end;
;
where var_n NE &cid;
run; 

proc sql THREADS;
create table &DATAWRK..MAX_D_&cvar as
select max(var_n) as MAX_VAR
from &DATAWRK..for_blr_&cvar;
quit;

data _null_;
set &DATAWRK..MAX_D_&cvar;
call symput('max_v', put(MAX_VAR,20.));
run;

%nrstr(%%)let max_=&max_v;

data &DATAWRK..DC_BLR_&cvar;
set &DATAWRK..DC_BLR_&cvar;
var_n=%eval(&max_ +1);
run;

data &DATAWRK..CC_BLR_&cvar;
set &DATAWRK..CC_BLR_&cvar;
var_n=%eval(&max_ + 2);
run;

data &DATAWRK..VIS_BLR_&cvar;
set &DATAWRK..VIS_BLR_&cvar;
var_n=%eval(&max_ + 3);
run;

%if &CHA_BLR=1 %then %do;
data &DATAWRK..CHA_BLR_&cvar;
set &DATAWRK..CHA_BLR_&cvar;
var_n=%eval(&max_ + 4);
run;
%end;

data &DATAWRK..for_blr_&cvar;
set &DATAWRK..for_blr_&cvar
%if &DC_BLR=1 %then %do; &DATAWRK..DC_BLR_&cvar (where=( value NE 0)) %end;
%if &CC_BLR=1 %then %do; &DATAWRK..CC_BLR_&cvar (where=( value NE 0)) %end;
%if &VIS_BLR=1 %then %do; &DATAWRK..VIS_BLR_&cvar (where=( value NE 0)) %end;
%if &CHA_BLR=1 %then %do; 
%if &RRUN=1 %then %do; 
&DATAWRK..CHA_BLR_&cvar 
%end;
%end;
;
run;

data &DATAWRK.._for_regr_y_&cvar (keep=Person_id y); 
set &DATAWRK.._for_regr2_&cvar;
if y=0 then y=-1;
run;

proc sort data=&DATAWRK..for_blr_&cvar;
by Person_id;
run;

proc sort data=&DATAWRK.._for_regr_y_&cvar;
by Person_id;
run;

data &DATAWRK..for_blr_&cvar;
merge &DATAWRK..for_blr_&cvar &DATAWRK.._for_regr_y_&cvar;
by Person_id;
run; 

proc sort data=&DATAWRK..for_blr_&cvar out=&DATAWRK..reports_u_&cvar (keep=Person_id) NODUPKEY;
by Person_id;
run;

data &DATAWRK..reports_u_&cvar;
set &DATAWRK..reports_u_&cvar;
report_d=_n_;
run;

proc sort data=&DATAWRK..for_blr_&cvar;
by Person_id;
run;

data &DATAWRK..for_blr_&cvar (drop=Person_id);
merge &DATAWRK..for_blr_&cvar &DATAWRK..reports_u_&cvar;
by Person_id;
run;

proc sql THREADS;
create table &DATAWRK..var_freq_&cvar as
select T1.var_n, count(T1.var_n) as var_n_freq
from &DATAWRK..for_blr_&cvar T1
group by T1.var_n;
quit;

proc sort data=&DATAWRK..var_freq_&cvar;
by DESCENDING var_n_freq;
run;

data &DATAWRK..var_n_new_&cvar;
set &DATAWRK..var_freq_&cvar;
var_n_new=_n_;
run;

proc sql THREADS;
create table &DATAWRK..report_data_new_&cvar as
select T1.y, T1.report_d, T2.var_n_new as var_n, T1.value
from &DATAWRK..for_blr_&cvar T1, &DATAWRK..var_n_new_&cvar T2
where T1.var_n=T2.var_n
order by T1.report_d, T2.var_n_new;
quit;

proc sql THREADS;
create table &DATAWRK..report_data_new_&cvar as
select T1.y, T1.report_d, T2.var_n_new as var_n, T1.value
from &DATAWRK..for_blr_&cvar T1, &DATAWRK..var_n_new_&cvar T2
where T1.var_n=T2.var_n
order by T1.report_d, T2.var_n_new;
quit;

proc iml;

USE &DATAWRK..report_data_new_&cvar; 
READ all var{report_d var_n y value};
CLOSE &DATAWRK..report_data_new_&cvar;

N=nrow(y);

c_EVENT=1;

filename out "&DIRE./bbr_in_&cvar..txt"; 
file out lrecl=1000000; 
      do i=1 to N;
if y[i]=c_EVENT then put('1') $1. @; 
else put('-1') $2. @;
here1:
x=var_n[i]; x=char(x); x=compbl(x);
vx=length(x);
put(x) $varying12. vx @;
put(':') @;
x=value[i]; x=char(x); x=compbl(x);
vx=length(x);
put(x) $varying12. vx @;


if i<N then if report_d[i]=report_d[i+1] then
do; i=i+1; GOTO here1; end;

put;
      end;
          
   closefile out;

quit;


data _null_;
x "C:\BBR\BBRtrain.exe -p 2 -V &HYPER &DIRE./bbr_in_&cvar..txt &DIRE./file_out_&cvar..txt";
run;
quit;

DATA 	&DATAWRK..Features_&cvar (keep=feature)
		&DATAWRK..Beta&cvar (keep=beta);
 retain indicator 0;
   LENGTH WORDTEXT $ 20;
   INFILE "&DIRE./file_out_&cvar..txt" FLOWOVER lrecl=100000;
   INPUT WORDTEXT @@;
if (indicator EQ 1) AND (WORDTEXT NE 'beta') then do; feature=input(WORDTEXT,best12.0); output &DATAWRK..Features_&cvar; end;
if (indicator EQ 2) AND (WORDTEXT NE 'threshold') then do; beta=input(WORDTEXT,20.0); output &DATAWRK..Beta&cvar; end;
if WORDTEXT EQ 'topicFeats' then indicator=1;
if WORDTEXT EQ 'beta' 		then indicator=2;
if WORDTEXT EQ 'threshold' 	then indicator=3;
RUN;

data &DATAWRK..Beta&cvar (rename=(beta=score));
set &DATAWRK..Beta&cvar end=last;
if last then delete;
run;

	data &DATAWRK..Beta&cvar (where=(Drug_concept_id=&did));
	merge &DATAWRK..var_n_new_&cvar (rename=(var_n=Drug_concept_id)) &DATAWRK..Beta&cvar;
	keep Drug_concept_id score Condition_concept_id;
	Condition_concept_id=&cid;
    run; 
 /* standard dev */
proc sort data=&DATAWRK..report_data_new_&cvar out=&DATAWRK..reports_uni_&cvar (keep=report_d) NODUPKEY;
by report_d;
run;

proc sql THREADS;
create table &DATAWRK..MAX_REP_&cvar as
select max(report_d) as MAX_VAR
from &DATAWRK..reports_uni_&cvar;
quit;

data _null_;
set &DATAWRK..MAX_REP_&cvar;
call symput('max_rep', put(MAX_VAR,20.));
run;

%nrstr(%%)let max_r=&max_rep;

proc surveyselect data=&DATAWRK..reports_uni_&cvar  method = urs sampsize = %eval(&max_r+0)
   rep=&B seed=12345 out=&DATAWRK..reports_s_&cvar;
   id report_d;
run;
/* for sd */

%nrstr(%%)let rep=0;

data &DATAWRK..Beta_alls_&cvar;
set _null_;
run;

%do rn=1 %to &B;

%nrstr(%%)let rep=%eval(&rep+1);


data &DATAWRK..reports_s2_&cvar (keep=report_d report_dn);
retain report_dn 0;
set &DATAWRK..reports_s_&cvar;
do i=1 to NumberHits;
report_dn=report_dn+1;
output;
end;
where replicate=&rep; /* NB */
run; 

proc sql THREADS;
create table &DATAWRK..report_data_M_&cvar as
select T1.y, T1.var_n, T1.value, T2.report_dn as report_d
from &DATAWRK..report_data_new_&cvar T1, &DATAWRK..reports_s2_&cvar T2 
where T1.report_d = T2.report_d
order by T2.report_dn, T1.var_n; 

create table &DATAWRK..var_n_uni_&cvar as
select DISTINCT T1.var_n
from &DATAWRK..report_data_M_&cvar T1
order by T1.var_n;

quit;

proc iml;

USE &DATAWRK..report_data_M_&cvar; 

READ all var{report_d var_n y value};
CLOSE &DATAWRK..report_data_M_&cvar;

N=nrow(y);

c_EVENT=1;

filename out "&DIRE./bbr_in_&cvar..txt"; 
file out lrecl=1000000; 
      do i=1 to N;
if y[i]=c_EVENT then put('1') $1. @; 
else put('-1') $2. @;
here1:
x=var_n[i]; x=char(x); x=compbl(x);
vx=length(x);
put(x) $varying12. vx @;
put(':') @;
x=value[i]; x=char(x); x=compbl(x);
vx=length(x);
put(x) $varying12. vx @;


if i<N then if report_d[i]=report_d[i+1] then
do; i=i+1; GOTO here1; end;

put;
      end;
          
   closefile out;

quit;


data _null_;
x "C:\BBR\BBRtrain.exe -p 2 -V &HYPER &DIRE./bbr_in_&cvar..txt &DIRE./file_out_&cvar..txt";
run;
quit;

DATA 	&DATAWRK..Features_&cvar (keep=feature)
		&DATAWRK..Beta_&cvar._&rep (keep=beta);
 retain indicator 0;
   LENGTH WORDTEXT $ 20;
   INFILE "&DIRE./file_out_&cvar..txt" FLOWOVER lrecl=100000;
   INPUT WORDTEXT @@;
if (indicator EQ 1) AND (WORDTEXT NE 'beta') then do; feature=input(WORDTEXT,best12.0); output &DATAWRK..Features_&cvar; end;
if (indicator EQ 2) AND (WORDTEXT NE 'threshold') then do; beta=input(WORDTEXT,20.0); output &DATAWRK..Beta_&cvar._&rep; end;
if WORDTEXT EQ 'topicFeats' then indicator=1;
if WORDTEXT EQ 'beta' 		then indicator=2;
if WORDTEXT EQ 'threshold' 	then indicator=3;
RUN;

data &DATAWRK..Beta_&cvar._&rep (rename=(beta=score));
set &DATAWRK..Beta_&cvar._&rep end=last;
if last then delete;
run;

data &DATAWRK..Beta_&cvar._&rep;
merge &DATAWRK..var_n_uni_&cvar &DATAWRK..Beta_&cvar._&rep;
keep var_n score;
run; 

data &DATAWRK..Beta_alls_&cvar;
set &DATAWRK..Beta_alls_&cvar
&DATAWRK..Beta_&cvar._&rep;
run;

%if  (&DEL_INTERM=1)%then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete
Beta_&cvar._&rep
;
quit;
run;
data _null_;
  fileRef="ext2del";
  rc=filename(fileRef,"&DIRE./bbr_in_&cvar..txt");
  if rc=0 and fexist(fileRef) then rc=fdelete(fileRef);
  rc=filename(fileRef);
run; 

data _null_;
  fileRef="ext2del";
  rc=filename(fileRef,"&DIRE./file_out_&cvar..txt");
  if rc=0 and fexist(fileRef) then rc=fdelete(fileRef);
  rc=filename(fileRef);
run; 


data _null_;
  fileRef="ext2del";
  rc=filename(fileRef,"&DIRE./current_&cvar..txt");
  if rc=0 and fexist(fileRef) then rc=fdelete(fileRef);
  rc=filename(fileRef);
run; 
%end;

%end;

proc sql THREADS;
create table &DATAWRK..Beta_std_&cvar as
select T1.var_n, STD(T1.score) as sd
from &DATAWRK..Beta_alls_&cvar T1
group by T1.var_n;

create table &DATAWRK..Beta_std_fin_&cvar as
select T2.var_n as Drug_concept_id, T1.sd
from &DATAWRK..Beta_std_&cvar T1, &DATAWRK..Var_n_new_&cvar T2
where T1.var_n=T2.var_n_new
order by T2.var_n;
quit;

data &DATAWRK..Beta_std_fin_&cvar;
set &DATAWRK..Beta_std_fin_&cvar;
where Drug_concept_id=&did;
run;

data &DATAWRK..Beta&cvar;
merge &DATAWRK..Beta&cvar &DATAWRK..Beta_std_fin_&cvar;
by Drug_concept_id;
run;

%if  (&DEL_INTERM=1)%then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete
Beta_&cvar
Var_n_new_&cvar
Vis_blr_&cvar
_cases_drugs_&cvar
_for_regr_y_&cvar
_s_fr_r_&cvar
Beta_alls_&cvar
Beta_std_&cvar
Beta_std_fin_&cvar
Cc_blr_&cvar
Cnds_blr_&cvar
Dc_blr_&cvar
Drugs_blr_&cvar
Features_&cvar
Inter_blr_&cvar
Max_d_&cvar
Max_rep_&cvar
Reports_s2_&cvar
Reports_s_&cvar
Reports_uni_&cvar
Reports_u_&cvar
Report_data_m_&cvar
Report_data_new_&cvar
Var_freq_&cvar
_for_out1_&cvar
_for_out2_&cvar
Cha_blr_&cvar
For_blr_&cvar
;
quit;
run;
%end;
%end;
/**** end BLR ****/
%nrstr(%%)let cvar=%eval(&cvar+&BYNUM);
%end;

endrsubmit;
%end;

waitfor _all_ %do k=1 %to &bynum; ts5k&k %end;;
signoff _all_;


%if &clr=1 %then %do;
data &DATAWRK.._CLR_ALL_NEST;
set _null_;
run;

%do i=1 %to &TOT_ALL;
data &DATAWRK.._CLR_ALL_NEST;
set  &DATAWRK.._CLR_ALL_NEST &DATAWRK.._for_out_&i;
run;
%end;
%end;


%if &blr=1 %then %do;
data &DATAWRK.._BLR_ALL;
set _null_;
run;

%do i=1 %to &TOT_ALL; 
data &DATAWRK.._BLR_ALL;
set &DATAWRK.._BLR_ALL  &DATAWRK..Beta&i;
run;
%end;
%end;





%if  &del_interm=1 %then
%do;
proc datasets lib=WRK NOLIST NOWARN;
delete 
%do m=1 %to &TOT_ALL; Beta&m _for_out_&m Var_n_uni_&m 
Condition_era_&m
All_conds_drugs_&m
_cases_drugs_conditions_&m
_controls_drugs_conditions_&m
_controls_fin_&m
_for_regr2_&m
_for_regr_all_&m
Cnds_for_2_&m
_for_regr_pindex_&m
Cha_for_1_&m
Cha_for_2_&m
Dr_for_2_&m
Vis_for_2_&m
_cases_all_&m
_controls_all_&m
%end;
%do k=1 %to &bynum; Condition_era_&k
%if &RLR=0 %then %do;
_cases_drugs_conditions_&k
_controls_drugs_conditions_&k
_controls_fin_&k
_cases_&k
%end;
%end;
_s_for_r _s_for_r2
Cha_for_1 Cha_for_2 Cnds_for_2
Dr_for_2 Vis_for_2
_cases_drugs_for_regr
_cases_drugs_uni
_for_regr_all
_for_regr_pindex
;
quit;
run;
%end;


%if &s_window<0 %then 
%do; %let SW=%eval(-1*&s_window); %let dwindo=n&SW; %end; %else %let dwindo=&s_window;

%if &clr=1 %then %do;
%let filename3=&cc._run&rnm._&dbn._s&dwindo.b&B_days.de&days_enrolled.d&p_window_drugs.c&p_window_cond.p&num_passes.m&num_matches._vis_&vis._nest_&ind_ind._clr_cha_&cha._chw_&CHW._cow_&cow._drug_&drug_oc;

data _null_;
    %let _EFIERR_ = 0; 
    %let _EFIREC_ = 0; 
    file "&TEXT_OUT_DIR./&filename3..txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Drug_concept_id"
       ','
          "Condition_concept_id"
       ','
          "score"
	   ','
          "standard_error"
       ;
     end;
   set  &DATAWRK.._CLR_ALL_NEST   end=EFIEOD;
       format Drug_concept_id best12. ;
       format Condition_concept_id best12. ;
       format score best12. ;
	   format STDERR best12. ;
     do;
       EFIOUT + 1;
       put Drug_concept_id @;
       put Condition_concept_id @;
       put score @;
	   put STDERR;
       ;
     end;
    if _ERROR_ then call symputx('_EFIERR_',1);  
    if EFIEOD then call symputx('_EFIREC_',EFIOUT);
    run;
%end;


%if &blr=1 %then %do;

%let filename4=&cc._run&rnm._&dbn._s&dwindo.b&B_days.de&days_enrolled.d&p_window_drugs.c&p_window_cond.p&num_passes.m&num_matches._vis_&vis._nest_&ind_ind._blr_drug_&drug_oc;

data &DATAWRK..blr_params;
hyper_blr=&hyper;
cnds_blr=&cnds_blr;
vis_blr=&vis_blr;
dc_blr=&dc_blr;
cc_blr=&cc_blr;
cha_blr=&cha_blr;
cow=&cow;
chw=&CHW;
run;

data _null_;
    %let _EFIERR_ = 0; 
    %let _EFIREC_ = 0; 
    file "&TEXT_OUT_DIR./&filename4._param.txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Hyper"
       ','
          "cnds_blr"
       ','
          "vis_blr"
	   ','
          "dc_blr"
	   ','
          "cc_blr"
	   ','
          "cha_blr"
	   ','
          "cov_window"
	   ','
          "cha_window"
       ;
     end;
   set  &DATAWRK..blr_params   end=EFIEOD;
       format hyper_blr best12. ;
       format cnds_blr best12. ;
       format vis_blr best12. ;
	   format dc_blr best12. ;
	   format cc_blr best12. ;
       format cha_blr best12. ;
       format cow best12. ;
	   format chw best12. ;
     do;
       EFIOUT + 1;
       put hyper_blr @;
       put cnds_blr @;
       put vis_blr @;
	   put dc_blr @;
	   put cc_blr @;
       put cha_blr @;
       put cow @;
	   put chw;
       ;
     end;
    if _ERROR_ then call symputx('_EFIERR_',1);  
    if EFIEOD then call symputx('_EFIREC_',EFIOUT);
run;

data _null_;
    %let _EFIERR_ = 0; 
    %let _EFIREC_ = 0; 
    file "&TEXT_OUT_DIR./&filename4..txt" delimiter=',' DSD DROPOVER lrecl=32767;
    if _n_ = 1 then    
     do;
       put
          "Drug_concept_id"
       ','
          "Condition_concept_id"
       ','
          "score"
	   ','
          "standard_error"
       ;
     end;
   set  &DATAWRK.._BLR_ALL   end=EFIEOD;
       format Drug_concept_id best12. ;
       format Condition_concept_id best12. ;
       format score best12. ;
	   format sd best12. ;
     do;
       EFIOUT + 1;
       put Drug_concept_id @;
       put Condition_concept_id @;
       put score @;
	   put sd;
       ;
     end;
    if _ERROR_ then call symputx('_EFIERR_',1);  
    if EFIEOD then call symputx('_EFIREC_',EFIOUT);
    run;
%end;

%end; /* ind_ind=1 */
%end; /*CLR*/

%if  &del_interm=1 %then
%do;
    proc datasets lib=WRK KILL NOLIST NOWARN;
	quit;
	run;
%end;

%mend CC_method;

%CC_method(&datain, &wrkfolder, &datawrk, &dataout, &text_out_dir, &cc_parameters, &drugs_of_interest, &conditions_of_interest);

